# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class DialogueList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the DialogueList

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant that is the parent of the resource

        :returns: twilio.rest.autopilot.v1.assistant.dialogue.DialogueList
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueList
        """
        super(DialogueList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }

    def get(self, sid):
        """
        Constructs a DialogueContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.autopilot.v1.assistant.dialogue.DialogueContext
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueContext
        """
        return DialogueContext(self._version, assistant_sid=self._solution['assistant_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a DialogueContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.autopilot.v1.assistant.dialogue.DialogueContext
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueContext
        """
        return DialogueContext(self._version, assistant_sid=self._solution['assistant_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.DialogueList>'


class DialoguePage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the DialoguePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The SID of the Assistant that is the parent of the resource

        :returns: twilio.rest.autopilot.v1.assistant.dialogue.DialoguePage
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialoguePage
        """
        super(DialoguePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of DialogueInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.autopilot.v1.assistant.dialogue.DialogueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueInstance
        """
        return DialogueInstance(self._version, payload, assistant_sid=self._solution['assistant_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.DialoguePage>'


class DialogueContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid, sid):
        """
        Initialize the DialogueContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant that is the parent of the resource to fetch
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.autopilot.v1.assistant.dialogue.DialogueContext
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueContext
        """
        super(DialogueContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, 'sid': sid, }
        self._uri = '/Assistants/{assistant_sid}/Dialogues/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the DialogueInstance

        :returns: The fetched DialogueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return DialogueInstance(
            self._version,
            payload,
            assistant_sid=self._solution['assistant_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.DialogueContext {}>'.format(context)


class DialogueInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, assistant_sid, sid=None):
        """
        Initialize the DialogueInstance

        :returns: twilio.rest.autopilot.v1.assistant.dialogue.DialogueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueInstance
        """
        super(DialogueInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'assistant_sid': payload.get('assistant_sid'),
            'sid': payload.get('sid'),
            'data': payload.get('data'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'assistant_sid': assistant_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: DialogueContext for this DialogueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueContext
        """
        if self._context is None:
            self._context = DialogueContext(
                self._version,
                assistant_sid=self._solution['assistant_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assistant_sid(self):
        """
        :returns: The SID of the Assistant that is the parent of the resource
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def data(self):
        """
        :returns: The JSON string that describes the dialogue session object
        :rtype: dict
        """
        return self._properties['data']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Dialogue resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the DialogueInstance

        :returns: The fetched DialogueInstance
        :rtype: twilio.rest.autopilot.v1.assistant.dialogue.DialogueInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.DialogueInstance {}>'.format(context)
