/* KInterbasDB Python Package - Header File for Events Support
**
** Version 3.1
**
** The following contributors hold Copyright (C) over their respective
** portions of code (see license.txt for details):
**
** [Original Author (maintained through version 2.0-0.3.1):]
**   1998-2001 [alex]  Alexander Kuznetsov   <alexan@users.sourceforge.net>
** [Maintainers (after version 2.0-0.3.1):]
**   2001-2002 [maz]   Marek Isalski         <kinterbasdb@maz.nu>
**   2002-2004 [dsr]   David Rushby          <woodsplitter@rocketmail.com>
** [Contributors:]
**   2001      [eac]   Evgeny A. Cherkashin  <eugeneai@icc.ru>
**   2001-2002 [janez] Janez Jere            <janez.jere@void.si>
*/

#ifndef _KIEVENTS_H
#define _KIEVENTS_H

#include "_kinterbasdb.h"

#ifdef ENABLE_DB_EVENT_SUPPORT

#include "_kilock.h"

#include "_kievents_platform_defs.h"


#define EVENT_OK         0
#define EVENT_ERROR     -1
#define EVENT_TIMEOUT    1


/******************** HARD-CODED LIMITS:BEGIN ********************/

/* MAX_EVENT_NAMES is an IB/Firebird engine constraint that we could not
** surmount in kinterbasdb without an unreasonable amount of effort. */
#define MAX_EVENT_NAMES 15

/******************** HARD-CODED LIMITS:END ********************/


/******************** FUNCTION PROTOTYPES:BEGIN ********************/

/* These functions are registered for Python availability in
** the _kinterbasdb.c/kinterbasdb_GlobalMethods table. */
PyObject *pyob_event_conduit_new(PyObject *self, PyObject *args);
PyObject *pyob_event_conduit_wait(PyObject *self, PyObject *args);
PyObject *pyob_event_conduit_flush_queue(PyObject *self, PyObject *args);
PyObject *pyob_event_conduit_cancel(PyObject *self, PyObject *args);

/******************** FUNCTION PROTOTYPES:END ********************/


/******************** MODULE TYPE DEFINITIONS:BEGIN ********************/

typedef struct event_queue_item { /* definition of type EventQueueItem */
  long counts[MAX_EVENT_NAMES];

  struct event_queue_item *next;
} EventQueueItem;


typedef struct { /* definition of type EventQueue */
  PlatformEventType event;
  EventQueueItem *head;
} EventQueue;


typedef enum {none, after_initial_enqueue, dummy_run_complete} event_conduit_status;

typedef struct { /* definition of type EventConduitObject */
  PyObject_HEAD /* Python API - infrastructural macro. */

  EventQueue *queue;

  ISC_LONG *event_id;
  char *event_buffer;
  char *result_buffer;
  short buffer_length;

  PyObject *py_event_names;

  event_conduit_status status;

  /* Database connection associated with this conduit: */
  ConnectionObject *connection;

} EventConduitObject;


extern PyTypeObject EventConduitType;

/* Declarations of high-level functions that have platform-specific
** implementations: */
PlatformEventType platform_create_event_object(void);
void platform_free_event_object(PlatformEventType event);

int event_queue_wait(EventQueue *queue, long timeout_millis);
int event_queue_signal(EventQueue *queue);
int event_queue_unsignal(EventQueue *queue);


/******************** MODULE TYPE DEFINITIONS:END ********************/

#endif /* ENABLE_DB_EVENT_SUPPORT */

#endif /* if not def _KIEVENTS_H */
