# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._quota_operations import (
    build_create_or_update_request,
    build_get_request,
    build_list_request,
    build_update_request,
)
from .._vendor import MixinABC

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class QuotaOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.reservations.aio.AzureReservationAPI`'s
        :attr:`quota` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, subscription_id: str, provider_id: str, location: str, resource_name: str, **kwargs: Any
    ) -> _models.CurrentQuotaLimitBase:
        """Get the current quota (service limit) and usage of a resource. You can use the response from
        the GET operation to submit quota update request.

        :param subscription_id: Azure subscription ID. Required.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID. Required.
        :type provider_id: str
        :param location: Azure region. Required.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
         Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CurrentQuotaLimitBase or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-10-25"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CurrentQuotaLimitBase]

        request = build_get_request(
            subscription_id=subscription_id,
            provider_id=provider_id,
            location=location,
            resource_name=resource_name,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = self._deserialize("CurrentQuotaLimitBase", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore

    async def _create_or_update_initial(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: Union[_models.CurrentQuotaLimitBase, IO],
        **kwargs: Any
    ) -> Union[_models.CurrentQuotaLimitBase, _models.QuotaRequestSubmitResponse201]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-10-25"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.CurrentQuotaLimitBase, _models.QuotaRequestSubmitResponse201]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(create_quota_request, (IO, bytes)):
            _content = create_quota_request
        else:
            _json = self._serialize.body(create_quota_request, "CurrentQuotaLimitBase")

        request = build_create_or_update_request(
            subscription_id=subscription_id,
            provider_id=provider_id,
            location=location,
            resource_name=resource_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_or_update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("CurrentQuotaLimitBase", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("QuotaRequestSubmitResponse201", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_initial.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: _models.CurrentQuotaLimitBase,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[AsyncLROPoller[_models.CurrentQuotaLimitBase], AsyncLROPoller[_models.QuotaRequestSubmitResponse201]]:
        """Create or update the quota (service limits) of a resource to the requested value.
         Steps:


        #. Make the Get request to get the quota information for specific resource.
        #. To increase the quota, update the limit field in the response from Get request to new value.
        #. Submit the JSON to the quota request API to update the quota.
           The Create quota request may be constructed as follows. The PUT operation can be used to
        update the quota.

        :param subscription_id: Azure subscription ID. Required.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID. Required.
        :type provider_id: str
        :param location: Azure region. Required.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
         Required.
        :type resource_name: str
        :param create_quota_request: Quota requests payload. Required.
        :type create_quota_request: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either CurrentQuotaLimitBase or An instance
         of AsyncLROPoller that returns either QuotaRequestSubmitResponse201 or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.CurrentQuotaLimitBase] or
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.QuotaRequestSubmitResponse201]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[AsyncLROPoller[_models.CurrentQuotaLimitBase], AsyncLROPoller[_models.QuotaRequestSubmitResponse201]]:
        """Create or update the quota (service limits) of a resource to the requested value.
         Steps:


        #. Make the Get request to get the quota information for specific resource.
        #. To increase the quota, update the limit field in the response from Get request to new value.
        #. Submit the JSON to the quota request API to update the quota.
           The Create quota request may be constructed as follows. The PUT operation can be used to
        update the quota.

        :param subscription_id: Azure subscription ID. Required.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID. Required.
        :type provider_id: str
        :param location: Azure region. Required.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
         Required.
        :type resource_name: str
        :param create_quota_request: Quota requests payload. Required.
        :type create_quota_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either CurrentQuotaLimitBase or An instance
         of AsyncLROPoller that returns either QuotaRequestSubmitResponse201 or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.CurrentQuotaLimitBase] or
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.QuotaRequestSubmitResponse201]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: Union[_models.CurrentQuotaLimitBase, IO],
        **kwargs: Any
    ) -> Union[AsyncLROPoller[_models.CurrentQuotaLimitBase], AsyncLROPoller[_models.QuotaRequestSubmitResponse201]]:
        """Create or update the quota (service limits) of a resource to the requested value.
         Steps:


        #. Make the Get request to get the quota information for specific resource.
        #. To increase the quota, update the limit field in the response from Get request to new value.
        #. Submit the JSON to the quota request API to update the quota.
           The Create quota request may be constructed as follows. The PUT operation can be used to
        update the quota.

        :param subscription_id: Azure subscription ID. Required.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID. Required.
        :type provider_id: str
        :param location: Azure region. Required.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
         Required.
        :type resource_name: str
        :param create_quota_request: Quota requests payload. Is either a model type or a IO type.
         Required.
        :type create_quota_request: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either CurrentQuotaLimitBase or An instance
         of AsyncLROPoller that returns either QuotaRequestSubmitResponse201 or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.CurrentQuotaLimitBase] or
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.QuotaRequestSubmitResponse201]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-10-25"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CurrentQuotaLimitBase]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_or_update_initial(  # type: ignore
                subscription_id=subscription_id,
                provider_id=provider_id,
                location=location,
                resource_name=resource_name,
                create_quota_request=create_quota_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("CurrentQuotaLimitBase", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "original-uri"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore

    async def _update_initial(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: Union[_models.CurrentQuotaLimitBase, IO],
        **kwargs: Any
    ) -> Union[_models.CurrentQuotaLimitBase, _models.QuotaRequestSubmitResponse201]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-10-25"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.CurrentQuotaLimitBase, _models.QuotaRequestSubmitResponse201]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(create_quota_request, (IO, bytes)):
            _content = create_quota_request
        else:
            _json = self._serialize.body(create_quota_request, "CurrentQuotaLimitBase")

        request = build_update_request(
            subscription_id=subscription_id,
            provider_id=provider_id,
            location=location,
            resource_name=resource_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("CurrentQuotaLimitBase", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("QuotaRequestSubmitResponse201", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_initial.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore

    @overload
    async def begin_update(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: _models.CurrentQuotaLimitBase,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[AsyncLROPoller[_models.CurrentQuotaLimitBase], AsyncLROPoller[_models.QuotaRequestSubmitResponse201]]:
        """Update the quota (service limits) of this resource to the requested value.
          • To get the quota information for specific resource, send a GET request.
          • To increase the quota, update the limit field from the GET response to a new value.
          • To update the quota value, submit the JSON response to the quota request API to update the
        quota.
          • To update the quota. use the PATCH operation.

        :param subscription_id: Azure subscription ID. Required.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID. Required.
        :type provider_id: str
        :param location: Azure region. Required.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
         Required.
        :type resource_name: str
        :param create_quota_request: Payload for the quota request. Required.
        :type create_quota_request: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either CurrentQuotaLimitBase or An instance
         of AsyncLROPoller that returns either QuotaRequestSubmitResponse201 or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.CurrentQuotaLimitBase] or
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.QuotaRequestSubmitResponse201]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[AsyncLROPoller[_models.CurrentQuotaLimitBase], AsyncLROPoller[_models.QuotaRequestSubmitResponse201]]:
        """Update the quota (service limits) of this resource to the requested value.
          • To get the quota information for specific resource, send a GET request.
          • To increase the quota, update the limit field from the GET response to a new value.
          • To update the quota value, submit the JSON response to the quota request API to update the
        quota.
          • To update the quota. use the PATCH operation.

        :param subscription_id: Azure subscription ID. Required.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID. Required.
        :type provider_id: str
        :param location: Azure region. Required.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
         Required.
        :type resource_name: str
        :param create_quota_request: Payload for the quota request. Required.
        :type create_quota_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either CurrentQuotaLimitBase or An instance
         of AsyncLROPoller that returns either QuotaRequestSubmitResponse201 or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.CurrentQuotaLimitBase] or
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.QuotaRequestSubmitResponse201]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update(
        self,
        subscription_id: str,
        provider_id: str,
        location: str,
        resource_name: str,
        create_quota_request: Union[_models.CurrentQuotaLimitBase, IO],
        **kwargs: Any
    ) -> Union[AsyncLROPoller[_models.CurrentQuotaLimitBase], AsyncLROPoller[_models.QuotaRequestSubmitResponse201]]:
        """Update the quota (service limits) of this resource to the requested value.
          • To get the quota information for specific resource, send a GET request.
          • To increase the quota, update the limit field from the GET response to a new value.
          • To update the quota value, submit the JSON response to the quota request API to update the
        quota.
          • To update the quota. use the PATCH operation.

        :param subscription_id: Azure subscription ID. Required.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID. Required.
        :type provider_id: str
        :param location: Azure region. Required.
        :type location: str
        :param resource_name: The resource name for a resource provider, such as SKU name for
         Microsoft.Compute, Sku or TotalLowPriorityCores for Microsoft.MachineLearningServices.
         Required.
        :type resource_name: str
        :param create_quota_request: Payload for the quota request. Is either a model type or a IO
         type. Required.
        :type create_quota_request: ~azure.mgmt.reservations.models.CurrentQuotaLimitBase or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either CurrentQuotaLimitBase or An instance
         of AsyncLROPoller that returns either QuotaRequestSubmitResponse201 or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.CurrentQuotaLimitBase] or
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.reservations.models.QuotaRequestSubmitResponse201]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-10-25"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CurrentQuotaLimitBase]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._update_initial(  # type: ignore
                subscription_id=subscription_id,
                provider_id=provider_id,
                location=location,
                resource_name=resource_name,
                create_quota_request=create_quota_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("CurrentQuotaLimitBase", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "original-uri"}, **kwargs),
            )  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_update.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits/{resourceName}"}  # type: ignore

    @distributed_trace
    def list(
        self, subscription_id: str, provider_id: str, location: str, **kwargs: Any
    ) -> AsyncIterable["_models.CurrentQuotaLimitBase"]:
        """Gets a list of current quotas (service limits) and usage for all resources. The response from
        the list quota operation can be leveraged to request quota updates.

        :param subscription_id: Azure subscription ID. Required.
        :type subscription_id: str
        :param provider_id: Azure resource provider ID. Required.
        :type provider_id: str
        :param location: Azure region. Required.
        :type location: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CurrentQuotaLimitBase or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.reservations.models.CurrentQuotaLimitBase]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-10-25"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.QuotaLimits]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    subscription_id=subscription_id,
                    provider_id=provider_id,
                    location=location,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("QuotaLimits", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ExceptionResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/resourceProviders/{providerId}/locations/{location}/serviceLimits"}  # type: ignore
