# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from msrest import Deserializer, Serializer

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models
from ._configuration import PostgreSQLManagementClientConfiguration
from .operations import BackupsOperations, CheckNameAvailabilityOperations, ConfigurationsOperations, DatabasesOperations, FirewallRulesOperations, GetPrivateDnsZoneSuffixOperations, LocationBasedCapabilitiesOperations, Operations, ServersOperations, VirtualNetworkSubnetUsageOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential

class PostgreSQLManagementClient:    # pylint: disable=too-many-instance-attributes
    """The Microsoft Azure management API provides create, read, update, and delete functionality for
    Azure PostgreSQL resources including servers, databases, firewall rules, VNET rules, security
    alert policies, log files and configurations with new business model.

    :ivar databases: DatabasesOperations operations
    :vartype databases: azure.mgmt.rdbms.postgresql_flexibleservers.operations.DatabasesOperations
    :ivar get_private_dns_zone_suffix: GetPrivateDnsZoneSuffixOperations operations
    :vartype get_private_dns_zone_suffix:
     azure.mgmt.rdbms.postgresql_flexibleservers.operations.GetPrivateDnsZoneSuffixOperations
    :ivar servers: ServersOperations operations
    :vartype servers: azure.mgmt.rdbms.postgresql_flexibleservers.operations.ServersOperations
    :ivar backups: BackupsOperations operations
    :vartype backups: azure.mgmt.rdbms.postgresql_flexibleservers.operations.BackupsOperations
    :ivar firewall_rules: FirewallRulesOperations operations
    :vartype firewall_rules:
     azure.mgmt.rdbms.postgresql_flexibleservers.operations.FirewallRulesOperations
    :ivar configurations: ConfigurationsOperations operations
    :vartype configurations:
     azure.mgmt.rdbms.postgresql_flexibleservers.operations.ConfigurationsOperations
    :ivar check_name_availability: CheckNameAvailabilityOperations operations
    :vartype check_name_availability:
     azure.mgmt.rdbms.postgresql_flexibleservers.operations.CheckNameAvailabilityOperations
    :ivar location_based_capabilities: LocationBasedCapabilitiesOperations operations
    :vartype location_based_capabilities:
     azure.mgmt.rdbms.postgresql_flexibleservers.operations.LocationBasedCapabilitiesOperations
    :ivar virtual_network_subnet_usage: VirtualNetworkSubnetUsageOperations operations
    :vartype virtual_network_subnet_usage:
     azure.mgmt.rdbms.postgresql_flexibleservers.operations.VirtualNetworkSubnetUsageOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.rdbms.postgresql_flexibleservers.operations.Operations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-01-20-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = PostgreSQLManagementClientConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.databases = DatabasesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.get_private_dns_zone_suffix = GetPrivateDnsZoneSuffixOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.servers = ServersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.backups = BackupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_rules = FirewallRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.configurations = ConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.check_name_availability = CheckNameAvailabilityOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.location_based_capabilities = LocationBasedCapabilitiesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_network_subnet_usage = VirtualNetworkSubnetUsageOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize
        )


    def _send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> PostgreSQLManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
