# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class RestRequestAuthentication(msrest.serialization.Model):
    """The authentication information required in the REST health check request to the health provider.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ApiKeyAuthentication, RolloutIdentityAuthentication.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The authentication type.Constant filled by server.  Possible values
     include: "ApiKey", "RolloutIdentity".
    :type type: str or ~azure.mgmt.deploymentmanager.models.RestAuthType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'ApiKey': 'ApiKeyAuthentication', 'RolloutIdentity': 'RolloutIdentityAuthentication'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestRequestAuthentication, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class ApiKeyAuthentication(RestRequestAuthentication):
    """ApiKey authentication gives a name and a value that can be included in either the request header or query parameters.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The authentication type.Constant filled by server.  Possible values
     include: "ApiKey", "RolloutIdentity".
    :type type: str or ~azure.mgmt.deploymentmanager.models.RestAuthType
    :param name: Required. The key name of the authentication key/value pair.
    :type name: str
    :param in_property: Required. The location of the authentication key/value pair in the request.
     Possible values include: "Query", "Header".
    :type in_property: str or ~azure.mgmt.deploymentmanager.models.RestAuthLocation
    :param value: Required. The value of the authentication key/value pair.
    :type value: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
        'in_property': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'in_property': {'key': 'in', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiKeyAuthentication, self).__init__(**kwargs)
        self.type = 'ApiKey'  # type: str
        self.name = kwargs['name']
        self.in_property = kwargs['in_property']
        self.value = kwargs['value']


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class ArtifactSource(TrackedResource):
    """The resource that defines the source location where the artifacts are located.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param source_type: The type of artifact source used.
    :type source_type: str
    :param artifact_root: The path from the location that the 'authentication' property [say, a SAS
     URI to the blob container] refers to, to the location of the artifacts. This can be used to
     differentiate different versions of the artifacts. Or, different types of artifacts like
     binaries or templates. The location referenced by the authentication property concatenated with
     this optional artifactRoot path forms the artifact source location where the artifacts are
     expected to be found.
    :type artifact_root: str
    :param authentication: The authentication method to use to access the artifact source.
    :type authentication: ~azure.mgmt.deploymentmanager.models.Authentication
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'artifact_root': {'key': 'properties.artifactRoot', 'type': 'str'},
        'authentication': {'key': 'properties.authentication', 'type': 'Authentication'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArtifactSource, self).__init__(**kwargs)
        self.source_type = kwargs.get('source_type', None)
        self.artifact_root = kwargs.get('artifact_root', None)
        self.authentication = kwargs.get('authentication', None)


class ArtifactSourceProperties(msrest.serialization.Model):
    """The properties that define the source location where the artifacts are located.

    All required parameters must be populated in order to send to Azure.

    :param source_type: Required. The type of artifact source used.
    :type source_type: str
    :param artifact_root: The path from the location that the 'authentication' property [say, a SAS
     URI to the blob container] refers to, to the location of the artifacts. This can be used to
     differentiate different versions of the artifacts. Or, different types of artifacts like
     binaries or templates. The location referenced by the authentication property concatenated with
     this optional artifactRoot path forms the artifact source location where the artifacts are
     expected to be found.
    :type artifact_root: str
    :param authentication: Required. The authentication method to use to access the artifact
     source.
    :type authentication: ~azure.mgmt.deploymentmanager.models.Authentication
    """

    _validation = {
        'source_type': {'required': True},
        'authentication': {'required': True},
    }

    _attribute_map = {
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'artifact_root': {'key': 'artifactRoot', 'type': 'str'},
        'authentication': {'key': 'authentication', 'type': 'Authentication'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArtifactSourceProperties, self).__init__(**kwargs)
        self.source_type = kwargs['source_type']
        self.artifact_root = kwargs.get('artifact_root', None)
        self.authentication = kwargs['authentication']


class ArtifactSourcePropertiesAutoGenerated(ArtifactSourceProperties):
    """The properties that define the artifact source.

    All required parameters must be populated in order to send to Azure.

    :param source_type: Required. The type of artifact source used.
    :type source_type: str
    :param artifact_root: The path from the location that the 'authentication' property [say, a SAS
     URI to the blob container] refers to, to the location of the artifacts. This can be used to
     differentiate different versions of the artifacts. Or, different types of artifacts like
     binaries or templates. The location referenced by the authentication property concatenated with
     this optional artifactRoot path forms the artifact source location where the artifacts are
     expected to be found.
    :type artifact_root: str
    :param authentication: Required. The authentication method to use to access the artifact
     source.
    :type authentication: ~azure.mgmt.deploymentmanager.models.Authentication
    """

    _validation = {
        'source_type': {'required': True},
        'authentication': {'required': True},
    }

    _attribute_map = {
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'artifact_root': {'key': 'artifactRoot', 'type': 'str'},
        'authentication': {'key': 'authentication', 'type': 'Authentication'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArtifactSourcePropertiesAutoGenerated, self).__init__(**kwargs)


class Authentication(msrest.serialization.Model):
    """Defines the authentication method and properties to access the artifacts.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SasAuthentication.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The authentication type.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Sas': 'SasAuthentication'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Authentication, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class CloudErrorBody(msrest.serialization.Model):
    """Detailed error information of any failure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code string.
    :vartype code: str
    :ivar message: Descriptive error information.
    :vartype message: str
    :param target: Error target.
    :type target: str
    :param details: More detailed error information.
    :type details: list[~azure.mgmt.deploymentmanager.models.CloudErrorBody]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class HealthCheckStepAttributes(msrest.serialization.Model):
    """The attributes for the health check step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RestHealthCheckStepAttributes.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of health check.Constant filled by server.
    :type type: str
    :param wait_duration: The duration in ISO 8601 format for which health check waits idly without
     any checks.
    :type wait_duration: str
    :param max_elastic_duration: The duration in ISO 8601 format for which the health check waits
     for the resource to become healthy. Health check fails if it doesn't. Health check starts to
     enforce healthyStateDuration once resource becomes healthy.
    :type max_elastic_duration: str
    :param healthy_state_duration: Required. The duration in ISO 8601 format for which the resource
     is expected to be continuously healthy. If maxElasticDuration is specified, healthy state
     duration is enforced after the detection of first healthy signal.
    :type healthy_state_duration: str
    """

    _validation = {
        'type': {'required': True},
        'healthy_state_duration': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'wait_duration': {'key': 'waitDuration', 'type': 'str'},
        'max_elastic_duration': {'key': 'maxElasticDuration', 'type': 'str'},
        'healthy_state_duration': {'key': 'healthyStateDuration', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'REST': 'RestHealthCheckStepAttributes'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthCheckStepAttributes, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.wait_duration = kwargs.get('wait_duration', None)
        self.max_elastic_duration = kwargs.get('max_elastic_duration', None)
        self.healthy_state_duration = kwargs['healthy_state_duration']


class StepProperties(msrest.serialization.Model):
    """The properties of a step resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: HealthCheckStepProperties, WaitStepProperties.

    All required parameters must be populated in order to send to Azure.

    :param step_type: Required. The type of step.Constant filled by server.  Possible values
     include: "Wait", "HealthCheck".
    :type step_type: str or ~azure.mgmt.deploymentmanager.models.StepType
    """

    _validation = {
        'step_type': {'required': True},
    }

    _attribute_map = {
        'step_type': {'key': 'stepType', 'type': 'str'},
    }

    _subtype_map = {
        'step_type': {'HealthCheck': 'HealthCheckStepProperties', 'Wait': 'WaitStepProperties'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StepProperties, self).__init__(**kwargs)
        self.step_type = None  # type: Optional[str]


class HealthCheckStepProperties(StepProperties):
    """Defines the properties of a health check step.

    All required parameters must be populated in order to send to Azure.

    :param step_type: Required. The type of step.Constant filled by server.  Possible values
     include: "Wait", "HealthCheck".
    :type step_type: str or ~azure.mgmt.deploymentmanager.models.StepType
    :param attributes: Required. The health check step attributes.
    :type attributes: ~azure.mgmt.deploymentmanager.models.HealthCheckStepAttributes
    """

    _validation = {
        'step_type': {'required': True},
        'attributes': {'required': True},
    }

    _attribute_map = {
        'step_type': {'key': 'stepType', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'HealthCheckStepAttributes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HealthCheckStepProperties, self).__init__(**kwargs)
        self.step_type = 'HealthCheck'  # type: str
        self.attributes = kwargs['attributes']


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The identity type.
    :type type: str
    :param identity_ids: Required. The list of identities.
    :type identity_ids: list[str]
    """

    _validation = {
        'type': {'required': True},
        'identity_ids': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'identity_ids': {'key': 'identityIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.identity_ids = kwargs['identity_ids']


class Message(msrest.serialization.Model):
    """Supplementary contextual messages during a rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_stamp: Time in UTC this message was provided.
    :vartype time_stamp: ~datetime.datetime
    :ivar message: The actual message text.
    :vartype message: str
    """

    _validation = {
        'time_stamp': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Message, self).__init__(**kwargs)
        self.time_stamp = None
        self.message = None


class Operation(msrest.serialization.Model):
    """Represents an operation that can be performed on the service.

    :param name: The name of the operation.
    :type name: str
    :param display: The display name of the operation.
    :type display: ~azure.mgmt.deploymentmanager.models.OperationDetail
    :param origin: The origin of the operation.
    :type origin: str
    :param properties: The properties of the operation.
    :type properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDetail'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationDetail(msrest.serialization.Model):
    """The detail about an operation.

    :param provider: The name of the provider that supports the operation.
    :type provider: str
    :param resource: The resource type on which this operation can be performed.
    :type resource: str
    :param operation: The name of the operation.
    :type operation: str
    :param description: The description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDetail, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationsList(msrest.serialization.Model):
    """The operations response.

    :param value: The list of supported operations.
    :type value: ~azure.mgmt.deploymentmanager.models.Operation
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'Operation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrePostStep(msrest.serialization.Model):
    """The properties that define a step.

    All required parameters must be populated in order to send to Azure.

    :param step_id: Required. The resource Id of the step to be run.
    :type step_id: str
    """

    _validation = {
        'step_id': {'required': True},
    }

    _attribute_map = {
        'step_id': {'key': 'stepId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrePostStep, self).__init__(**kwargs)
        self.step_id = kwargs['step_id']


class ResourceOperation(msrest.serialization.Model):
    """Individual resource operation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param resource_name: Name of the resource as specified in the artifacts. For ARM resources,
     this is the name of the resource specified in the template.
    :type resource_name: str
    :ivar operation_id: Unique identifier of the operation. For ARM resources, this is the
     operationId obtained from ARM service.
    :vartype operation_id: str
    :param resource_type: Type of the resource as specified in the artifacts. For ARM resources,
     this is the type of the resource specified in the template.
    :type resource_type: str
    :ivar provisioning_state: State of the resource deployment. For ARM resources, this is the
     current provisioning state of the resource.
    :vartype provisioning_state: str
    :ivar status_message: Descriptive information of the resource operation.
    :vartype status_message: str
    :ivar status_code: Http status code of the operation.
    :vartype status_code: str
    """

    _validation = {
        'operation_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status_message': {'readonly': True},
        'status_code': {'readonly': True},
    }

    _attribute_map = {
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceOperation, self).__init__(**kwargs)
        self.resource_name = kwargs.get('resource_name', None)
        self.operation_id = None
        self.resource_type = kwargs.get('resource_type', None)
        self.provisioning_state = None
        self.status_message = None
        self.status_code = None


class RestHealthCheck(msrest.serialization.Model):
    """A REST based health check.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A unique name for this check.
    :type name: str
    :param request: Required. The request to the health provider.
    :type request: ~azure.mgmt.deploymentmanager.models.RestRequest
    :param response: The expected response from the health provider. If no expected response is
     provided, the default is to expect the received response to have an HTTP status code of 200 OK.
    :type response: ~azure.mgmt.deploymentmanager.models.RestResponse
    """

    _validation = {
        'name': {'required': True},
        'request': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'request': {'key': 'request', 'type': 'RestRequest'},
        'response': {'key': 'response', 'type': 'RestResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestHealthCheck, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.request = kwargs['request']
        self.response = kwargs.get('response', None)


class RestHealthCheckStepAttributes(HealthCheckStepAttributes):
    """Defines the REST health check step properties.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of health check.Constant filled by server.
    :type type: str
    :param wait_duration: The duration in ISO 8601 format for which health check waits idly without
     any checks.
    :type wait_duration: str
    :param max_elastic_duration: The duration in ISO 8601 format for which the health check waits
     for the resource to become healthy. Health check fails if it doesn't. Health check starts to
     enforce healthyStateDuration once resource becomes healthy.
    :type max_elastic_duration: str
    :param healthy_state_duration: Required. The duration in ISO 8601 format for which the resource
     is expected to be continuously healthy. If maxElasticDuration is specified, healthy state
     duration is enforced after the detection of first healthy signal.
    :type healthy_state_duration: str
    :param health_checks: The list of checks that form the health check step.
    :type health_checks: list[~azure.mgmt.deploymentmanager.models.RestHealthCheck]
    """

    _validation = {
        'type': {'required': True},
        'healthy_state_duration': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'wait_duration': {'key': 'waitDuration', 'type': 'str'},
        'max_elastic_duration': {'key': 'maxElasticDuration', 'type': 'str'},
        'healthy_state_duration': {'key': 'healthyStateDuration', 'type': 'str'},
        'health_checks': {'key': 'properties.healthChecks', 'type': '[RestHealthCheck]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestHealthCheckStepAttributes, self).__init__(**kwargs)
        self.type = 'REST'  # type: str
        self.health_checks = kwargs.get('health_checks', None)


class RestRequest(msrest.serialization.Model):
    """The properties that make up a REST request.

    All required parameters must be populated in order to send to Azure.

    :param method: Required. The HTTP method to use for the request. Possible values include:
     "GET", "POST".
    :type method: str or ~azure.mgmt.deploymentmanager.models.RestRequestMethod
    :param uri: Required. The HTTP URI to use for the request.
    :type uri: str
    :param authentication: Required. The authentication information required in the request to the
     health provider.
    :type authentication: ~azure.mgmt.deploymentmanager.models.RestRequestAuthentication
    """

    _validation = {
        'method': {'required': True},
        'uri': {'required': True},
        'authentication': {'required': True},
    }

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'authentication': {'key': 'authentication', 'type': 'RestRequestAuthentication'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestRequest, self).__init__(**kwargs)
        self.method = kwargs['method']
        self.uri = kwargs['uri']
        self.authentication = kwargs['authentication']


class RestResponse(msrest.serialization.Model):
    """The properties that make up the expected REST response.

    :param success_status_codes: The HTTP status codes expected in a successful health check
     response. The response is expected to match one of the given status codes. If no expected
     status codes are provided, default expected status code is 200 OK.
    :type success_status_codes: list[str]
    :param regex: The regular expressions to match the response content with.
    :type regex: ~azure.mgmt.deploymentmanager.models.RestResponseRegex
    """

    _attribute_map = {
        'success_status_codes': {'key': 'successStatusCodes', 'type': '[str]'},
        'regex': {'key': 'regex', 'type': 'RestResponseRegex'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestResponse, self).__init__(**kwargs)
        self.success_status_codes = kwargs.get('success_status_codes', None)
        self.regex = kwargs.get('regex', None)


class RestResponseRegex(msrest.serialization.Model):
    """The regular expressions to match the response content with.

    :param matches: The list of regular expressions.
    :type matches: list[str]
    :param match_quantifier: Indicates whether any or all of the expressions should match with the
     response content. Possible values include: "All", "Any".
    :type match_quantifier: str or ~azure.mgmt.deploymentmanager.models.RestMatchQuantifier
    """

    _attribute_map = {
        'matches': {'key': 'matches', 'type': '[str]'},
        'match_quantifier': {'key': 'matchQuantifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestResponseRegex, self).__init__(**kwargs)
        self.matches = kwargs.get('matches', None)
        self.match_quantifier = kwargs.get('match_quantifier', None)


class Rollout(TrackedResource):
    """Defines the rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: Identity for the resource.
    :type identity: ~azure.mgmt.deploymentmanager.models.Identity
    :param build_version: The version of the build being deployed.
    :type build_version: str
    :param artifact_source_id: The reference to the artifact source resource Id where the payload
     is located.
    :type artifact_source_id: str
    :param target_service_topology_id: The resource Id of the service topology from which service
     units are being referenced in step groups to be deployed.
    :type target_service_topology_id: str
    :param step_groups: The list of step groups that define the orchestration.
    :type step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
    :ivar status: The current status of the rollout.
    :vartype status: str
    :ivar total_retry_attempts: The cardinal count of total number of retries performed on the
     rollout at a given time.
    :vartype total_retry_attempts: int
    :ivar operation_info: Operational information of the rollout.
    :vartype operation_info: ~azure.mgmt.deploymentmanager.models.RolloutOperationInfo
    :ivar services: The detailed information on the services being deployed.
    :vartype services: list[~azure.mgmt.deploymentmanager.models.Service]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'status': {'readonly': True},
        'total_retry_attempts': {'readonly': True},
        'operation_info': {'readonly': True},
        'services': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'build_version': {'key': 'properties.buildVersion', 'type': 'str'},
        'artifact_source_id': {'key': 'properties.artifactSourceId', 'type': 'str'},
        'target_service_topology_id': {'key': 'properties.targetServiceTopologyId', 'type': 'str'},
        'step_groups': {'key': 'properties.stepGroups', 'type': '[StepGroup]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'total_retry_attempts': {'key': 'properties.totalRetryAttempts', 'type': 'int'},
        'operation_info': {'key': 'properties.operationInfo', 'type': 'RolloutOperationInfo'},
        'services': {'key': 'properties.services', 'type': '[Service]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Rollout, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.build_version = kwargs.get('build_version', None)
        self.artifact_source_id = kwargs.get('artifact_source_id', None)
        self.target_service_topology_id = kwargs.get('target_service_topology_id', None)
        self.step_groups = kwargs.get('step_groups', None)
        self.status = None
        self.total_retry_attempts = None
        self.operation_info = None
        self.services = None


class RolloutIdentityAuthentication(RestRequestAuthentication):
    """RolloutIdentity uses the user-assigned managed identity authentication context specified in the Identity property during rollout creation.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The authentication type.Constant filled by server.  Possible values
     include: "ApiKey", "RolloutIdentity".
    :type type: str or ~azure.mgmt.deploymentmanager.models.RestAuthType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RolloutIdentityAuthentication, self).__init__(**kwargs)
        self.type = 'RolloutIdentity'  # type: str


class RolloutOperationInfo(msrest.serialization.Model):
    """Detailed runtime information of the rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar retry_attempt: The ordinal count of the number of retry attempts on a rollout. 0 if no
     retries of the rollout have been performed. If the rollout is updated with a PUT, this count is
     reset to 0.
    :vartype retry_attempt: int
    :ivar skip_succeeded_on_retry: True, if all steps that succeeded on the previous run/attempt
     were chosen to be skipped in this retry attempt. False, otherwise.
    :vartype skip_succeeded_on_retry: bool
    :ivar start_time: The start time of the rollout in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The start time of the rollout in UTC. This property will not be set if the
     rollout has not completed yet.
    :vartype end_time: ~datetime.datetime
    :ivar error: The detailed error information for any failure.
    :vartype error: ~azure.mgmt.deploymentmanager.models.CloudErrorBody
    """

    _validation = {
        'retry_attempt': {'readonly': True},
        'skip_succeeded_on_retry': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'retry_attempt': {'key': 'retryAttempt', 'type': 'int'},
        'skip_succeeded_on_retry': {'key': 'skipSucceededOnRetry', 'type': 'bool'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RolloutOperationInfo, self).__init__(**kwargs)
        self.retry_attempt = None
        self.skip_succeeded_on_retry = None
        self.start_time = None
        self.end_time = None
        self.error = None


class RolloutProperties(msrest.serialization.Model):
    """Defines the properties of a rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The current status of the rollout.
    :vartype status: str
    :ivar total_retry_attempts: The cardinal count of total number of retries performed on the
     rollout at a given time.
    :vartype total_retry_attempts: int
    :ivar operation_info: Operational information of the rollout.
    :vartype operation_info: ~azure.mgmt.deploymentmanager.models.RolloutOperationInfo
    :ivar services: The detailed information on the services being deployed.
    :vartype services: list[~azure.mgmt.deploymentmanager.models.Service]
    """

    _validation = {
        'status': {'readonly': True},
        'total_retry_attempts': {'readonly': True},
        'operation_info': {'readonly': True},
        'services': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'total_retry_attempts': {'key': 'totalRetryAttempts', 'type': 'int'},
        'operation_info': {'key': 'operationInfo', 'type': 'RolloutOperationInfo'},
        'services': {'key': 'services', 'type': '[Service]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RolloutProperties, self).__init__(**kwargs)
        self.status = None
        self.total_retry_attempts = None
        self.operation_info = None
        self.services = None


class RolloutRequestProperties(msrest.serialization.Model):
    """The properties for defining a rollout.

    All required parameters must be populated in order to send to Azure.

    :param build_version: Required. The version of the build being deployed.
    :type build_version: str
    :param artifact_source_id: The reference to the artifact source resource Id where the payload
     is located.
    :type artifact_source_id: str
    :param target_service_topology_id: Required. The resource Id of the service topology from which
     service units are being referenced in step groups to be deployed.
    :type target_service_topology_id: str
    :param step_groups: Required. The list of step groups that define the orchestration.
    :type step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
    """

    _validation = {
        'build_version': {'required': True},
        'target_service_topology_id': {'required': True},
        'step_groups': {'required': True},
    }

    _attribute_map = {
        'build_version': {'key': 'buildVersion', 'type': 'str'},
        'artifact_source_id': {'key': 'artifactSourceId', 'type': 'str'},
        'target_service_topology_id': {'key': 'targetServiceTopologyId', 'type': 'str'},
        'step_groups': {'key': 'stepGroups', 'type': '[StepGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RolloutRequestProperties, self).__init__(**kwargs)
        self.build_version = kwargs['build_version']
        self.artifact_source_id = kwargs.get('artifact_source_id', None)
        self.target_service_topology_id = kwargs['target_service_topology_id']
        self.step_groups = kwargs['step_groups']


class RolloutPropertiesAutoGenerated(RolloutRequestProperties, RolloutProperties):
    """The properties that define a rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The current status of the rollout.
    :vartype status: str
    :ivar total_retry_attempts: The cardinal count of total number of retries performed on the
     rollout at a given time.
    :vartype total_retry_attempts: int
    :ivar operation_info: Operational information of the rollout.
    :vartype operation_info: ~azure.mgmt.deploymentmanager.models.RolloutOperationInfo
    :ivar services: The detailed information on the services being deployed.
    :vartype services: list[~azure.mgmt.deploymentmanager.models.Service]
    :param build_version: Required. The version of the build being deployed.
    :type build_version: str
    :param artifact_source_id: The reference to the artifact source resource Id where the payload
     is located.
    :type artifact_source_id: str
    :param target_service_topology_id: Required. The resource Id of the service topology from which
     service units are being referenced in step groups to be deployed.
    :type target_service_topology_id: str
    :param step_groups: Required. The list of step groups that define the orchestration.
    :type step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
    """

    _validation = {
        'status': {'readonly': True},
        'total_retry_attempts': {'readonly': True},
        'operation_info': {'readonly': True},
        'services': {'readonly': True},
        'build_version': {'required': True},
        'target_service_topology_id': {'required': True},
        'step_groups': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'total_retry_attempts': {'key': 'totalRetryAttempts', 'type': 'int'},
        'operation_info': {'key': 'operationInfo', 'type': 'RolloutOperationInfo'},
        'services': {'key': 'services', 'type': '[Service]'},
        'build_version': {'key': 'buildVersion', 'type': 'str'},
        'artifact_source_id': {'key': 'artifactSourceId', 'type': 'str'},
        'target_service_topology_id': {'key': 'targetServiceTopologyId', 'type': 'str'},
        'step_groups': {'key': 'stepGroups', 'type': '[StepGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RolloutPropertiesAutoGenerated, self).__init__(**kwargs)
        self.status = None
        self.total_retry_attempts = None
        self.operation_info = None
        self.services = None
        self.build_version = kwargs['build_version']
        self.artifact_source_id = kwargs.get('artifact_source_id', None)
        self.target_service_topology_id = kwargs['target_service_topology_id']
        self.step_groups = kwargs['step_groups']


class RolloutRequest(TrackedResource):
    """Defines the PUT rollout request body.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: Required. Identity for the resource.
    :type identity: ~azure.mgmt.deploymentmanager.models.Identity
    :param build_version: Required. The version of the build being deployed.
    :type build_version: str
    :param artifact_source_id: The reference to the artifact source resource Id where the payload
     is located.
    :type artifact_source_id: str
    :param target_service_topology_id: Required. The resource Id of the service topology from which
     service units are being referenced in step groups to be deployed.
    :type target_service_topology_id: str
    :param step_groups: Required. The list of step groups that define the orchestration.
    :type step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'identity': {'required': True},
        'build_version': {'required': True},
        'target_service_topology_id': {'required': True},
        'step_groups': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'build_version': {'key': 'properties.buildVersion', 'type': 'str'},
        'artifact_source_id': {'key': 'properties.artifactSourceId', 'type': 'str'},
        'target_service_topology_id': {'key': 'properties.targetServiceTopologyId', 'type': 'str'},
        'step_groups': {'key': 'properties.stepGroups', 'type': '[StepGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RolloutRequest, self).__init__(**kwargs)
        self.identity = kwargs['identity']
        self.build_version = kwargs['build_version']
        self.artifact_source_id = kwargs.get('artifact_source_id', None)
        self.target_service_topology_id = kwargs['target_service_topology_id']
        self.step_groups = kwargs['step_groups']


class RolloutStep(msrest.serialization.Model):
    """Defines a specific step on a target service unit.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the step.
    :type name: str
    :ivar status: Current state of the step.
    :vartype status: str
    :param step_group: The step group the current step is part of.
    :type step_group: str
    :ivar operation_info: Detailed information of specific action execution.
    :vartype operation_info: ~azure.mgmt.deploymentmanager.models.StepOperationInfo
    :ivar resource_operations: Set of resource operations that were performed, if any, on an Azure
     resource.
    :vartype resource_operations: list[~azure.mgmt.deploymentmanager.models.ResourceOperation]
    :ivar messages: Supplementary informative messages during rollout.
    :vartype messages: list[~azure.mgmt.deploymentmanager.models.Message]
    """

    _validation = {
        'name': {'required': True},
        'status': {'readonly': True},
        'operation_info': {'readonly': True},
        'resource_operations': {'readonly': True},
        'messages': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'step_group': {'key': 'stepGroup', 'type': 'str'},
        'operation_info': {'key': 'operationInfo', 'type': 'StepOperationInfo'},
        'resource_operations': {'key': 'resourceOperations', 'type': '[ResourceOperation]'},
        'messages': {'key': 'messages', 'type': '[Message]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RolloutStep, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.status = None
        self.step_group = kwargs.get('step_group', None)
        self.operation_info = None
        self.resource_operations = None
        self.messages = None


class SasAuthentication(Authentication):
    """Defines the properties to access the artifacts using an Azure Storage SAS URI.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The authentication type.Constant filled by server.
    :type type: str
    :param sas_uri: The SAS URI to the Azure Storage blob container. Any offset from the root of
     the container to where the artifacts are located can be defined in the artifactRoot.
    :type sas_uri: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'sas_uri': {'key': 'properties.sasUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SasAuthentication, self).__init__(**kwargs)
        self.type = 'Sas'  # type: str
        self.sas_uri = kwargs.get('sas_uri', None)


class ServiceProperties(msrest.serialization.Model):
    """The properties of a service.

    All required parameters must be populated in order to send to Azure.

    :param target_location: Required. The Azure location to which the resources in the service
     belong to or should be deployed to.
    :type target_location: str
    :param target_subscription_id: Required. The subscription to which the resources in the service
     belong to or should be deployed to.
    :type target_subscription_id: str
    """

    _validation = {
        'target_location': {'required': True},
        'target_subscription_id': {'required': True},
    }

    _attribute_map = {
        'target_location': {'key': 'targetLocation', 'type': 'str'},
        'target_subscription_id': {'key': 'targetSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceProperties, self).__init__(**kwargs)
        self.target_location = kwargs['target_location']
        self.target_subscription_id = kwargs['target_subscription_id']


class Service(ServiceProperties):
    """Defines a service.

    All required parameters must be populated in order to send to Azure.

    :param target_location: Required. The Azure location to which the resources in the service
     belong to or should be deployed to.
    :type target_location: str
    :param target_subscription_id: Required. The subscription to which the resources in the service
     belong to or should be deployed to.
    :type target_subscription_id: str
    :param name: Name of the service.
    :type name: str
    :param service_units: The detailed information about the units that make up the service.
    :type service_units: list[~azure.mgmt.deploymentmanager.models.ServiceUnit]
    """

    _validation = {
        'target_location': {'required': True},
        'target_subscription_id': {'required': True},
    }

    _attribute_map = {
        'target_location': {'key': 'targetLocation', 'type': 'str'},
        'target_subscription_id': {'key': 'targetSubscriptionId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'service_units': {'key': 'serviceUnits', 'type': '[ServiceUnit]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Service, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.service_units = kwargs.get('service_units', None)


class ServiceResource(TrackedResource):
    """The resource representation of a service in a service topology.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param target_location: Required. The Azure location to which the resources in the service
     belong to or should be deployed to.
    :type target_location: str
    :param target_subscription_id: Required. The subscription to which the resources in the service
     belong to or should be deployed to.
    :type target_subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'target_location': {'required': True},
        'target_subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'target_location': {'key': 'properties.targetLocation', 'type': 'str'},
        'target_subscription_id': {'key': 'properties.targetSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResource, self).__init__(**kwargs)
        self.target_location = kwargs['target_location']
        self.target_subscription_id = kwargs['target_subscription_id']


class ServiceResourceProperties(ServiceProperties):
    """The properties that define a service in a service topology.

    All required parameters must be populated in order to send to Azure.

    :param target_location: Required. The Azure location to which the resources in the service
     belong to or should be deployed to.
    :type target_location: str
    :param target_subscription_id: Required. The subscription to which the resources in the service
     belong to or should be deployed to.
    :type target_subscription_id: str
    """

    _validation = {
        'target_location': {'required': True},
        'target_subscription_id': {'required': True},
    }

    _attribute_map = {
        'target_location': {'key': 'targetLocation', 'type': 'str'},
        'target_subscription_id': {'key': 'targetSubscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceResourceProperties, self).__init__(**kwargs)


class ServiceTopologyProperties(msrest.serialization.Model):
    """The properties of a service topology.

    :param artifact_source_id: The resource Id of the artifact source that contains the artifacts
     that can be referenced in the service units.
    :type artifact_source_id: str
    """

    _attribute_map = {
        'artifact_source_id': {'key': 'artifactSourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceTopologyProperties, self).__init__(**kwargs)
        self.artifact_source_id = kwargs.get('artifact_source_id', None)


class ServiceTopologyResource(TrackedResource):
    """The resource representation of a service topology.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param artifact_source_id: The resource Id of the artifact source that contains the artifacts
     that can be referenced in the service units.
    :type artifact_source_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'artifact_source_id': {'key': 'properties.artifactSourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceTopologyResource, self).__init__(**kwargs)
        self.artifact_source_id = kwargs.get('artifact_source_id', None)


class ServiceTopologyResourceProperties(ServiceTopologyProperties):
    """The properties that define the service topology.

    :param artifact_source_id: The resource Id of the artifact source that contains the artifacts
     that can be referenced in the service units.
    :type artifact_source_id: str
    """

    _attribute_map = {
        'artifact_source_id': {'key': 'artifactSourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceTopologyResourceProperties, self).__init__(**kwargs)


class ServiceUnitProperties(msrest.serialization.Model):
    """Defines the properties of a service unit.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_group: Required. The Azure Resource Group to which the resources in the
     service unit belong to or should be deployed to.
    :type target_resource_group: str
    :param deployment_mode: Required. Describes the type of ARM deployment to be performed on the
     resource. Possible values include: "Incremental", "Complete".
    :type deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
    :param artifacts: The artifacts for the service unit.
    :type artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
    """

    _validation = {
        'target_resource_group': {'required': True},
        'deployment_mode': {'required': True},
    }

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'deployment_mode': {'key': 'deploymentMode', 'type': 'str'},
        'artifacts': {'key': 'artifacts', 'type': 'ServiceUnitArtifacts'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceUnitProperties, self).__init__(**kwargs)
        self.target_resource_group = kwargs['target_resource_group']
        self.deployment_mode = kwargs['deployment_mode']
        self.artifacts = kwargs.get('artifacts', None)


class ServiceUnit(ServiceUnitProperties):
    """Defines a service unit.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_group: Required. The Azure Resource Group to which the resources in the
     service unit belong to or should be deployed to.
    :type target_resource_group: str
    :param deployment_mode: Required. Describes the type of ARM deployment to be performed on the
     resource. Possible values include: "Incremental", "Complete".
    :type deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
    :param artifacts: The artifacts for the service unit.
    :type artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
    :param name: Name of the service unit.
    :type name: str
    :param steps: Detailed step information, if present.
    :type steps: list[~azure.mgmt.deploymentmanager.models.RolloutStep]
    """

    _validation = {
        'target_resource_group': {'required': True},
        'deployment_mode': {'required': True},
    }

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'deployment_mode': {'key': 'deploymentMode', 'type': 'str'},
        'artifacts': {'key': 'artifacts', 'type': 'ServiceUnitArtifacts'},
        'name': {'key': 'name', 'type': 'str'},
        'steps': {'key': 'steps', 'type': '[RolloutStep]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceUnit, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.steps = kwargs.get('steps', None)


class ServiceUnitArtifacts(msrest.serialization.Model):
    """Defines the artifacts of a service unit.

    :param template_uri: The full URI of the ARM template file with the SAS token.
    :type template_uri: str
    :param parameters_uri: The full URI of the ARM parameters file with the SAS token.
    :type parameters_uri: str
    :param template_artifact_source_relative_path: The path to the ARM template file relative to
     the artifact source.
    :type template_artifact_source_relative_path: str
    :param parameters_artifact_source_relative_path: The path to the ARM parameters file relative
     to the artifact source.
    :type parameters_artifact_source_relative_path: str
    """

    _attribute_map = {
        'template_uri': {'key': 'templateUri', 'type': 'str'},
        'parameters_uri': {'key': 'parametersUri', 'type': 'str'},
        'template_artifact_source_relative_path': {'key': 'templateArtifactSourceRelativePath', 'type': 'str'},
        'parameters_artifact_source_relative_path': {'key': 'parametersArtifactSourceRelativePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceUnitArtifacts, self).__init__(**kwargs)
        self.template_uri = kwargs.get('template_uri', None)
        self.parameters_uri = kwargs.get('parameters_uri', None)
        self.template_artifact_source_relative_path = kwargs.get('template_artifact_source_relative_path', None)
        self.parameters_artifact_source_relative_path = kwargs.get('parameters_artifact_source_relative_path', None)


class ServiceUnitResource(TrackedResource):
    """Represents the response of a service unit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param target_resource_group: Required. The Azure Resource Group to which the resources in the
     service unit belong to or should be deployed to.
    :type target_resource_group: str
    :param deployment_mode: Required. Describes the type of ARM deployment to be performed on the
     resource. Possible values include: "Incremental", "Complete".
    :type deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
    :param artifacts: The artifacts for the service unit.
    :type artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'target_resource_group': {'required': True},
        'deployment_mode': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'target_resource_group': {'key': 'properties.targetResourceGroup', 'type': 'str'},
        'deployment_mode': {'key': 'properties.deploymentMode', 'type': 'str'},
        'artifacts': {'key': 'properties.artifacts', 'type': 'ServiceUnitArtifacts'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceUnitResource, self).__init__(**kwargs)
        self.target_resource_group = kwargs['target_resource_group']
        self.deployment_mode = kwargs['deployment_mode']
        self.artifacts = kwargs.get('artifacts', None)


class ServiceUnitResourceProperties(ServiceUnitProperties):
    """The properties that define the service unit.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_group: Required. The Azure Resource Group to which the resources in the
     service unit belong to or should be deployed to.
    :type target_resource_group: str
    :param deployment_mode: Required. Describes the type of ARM deployment to be performed on the
     resource. Possible values include: "Incremental", "Complete".
    :type deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
    :param artifacts: The artifacts for the service unit.
    :type artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
    """

    _validation = {
        'target_resource_group': {'required': True},
        'deployment_mode': {'required': True},
    }

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'deployment_mode': {'key': 'deploymentMode', 'type': 'str'},
        'artifacts': {'key': 'artifacts', 'type': 'ServiceUnitArtifacts'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceUnitResourceProperties, self).__init__(**kwargs)


class StepGroup(msrest.serialization.Model):
    """The properties that define a Step group in a rollout.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the step group.
    :type name: str
    :param depends_on_step_groups: The list of step group names on which this step group depends
     on.
    :type depends_on_step_groups: list[str]
    :param pre_deployment_steps: The list of steps to be run before deploying the target.
    :type pre_deployment_steps: list[~azure.mgmt.deploymentmanager.models.PrePostStep]
    :param deployment_target_id: Required. The resource Id of service unit to be deployed. The
     service unit should be from the service topology referenced in targetServiceTopologyId.
    :type deployment_target_id: str
    :param post_deployment_steps: The list of steps to be run after deploying the target.
    :type post_deployment_steps: list[~azure.mgmt.deploymentmanager.models.PrePostStep]
    """

    _validation = {
        'name': {'required': True},
        'deployment_target_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'depends_on_step_groups': {'key': 'dependsOnStepGroups', 'type': '[str]'},
        'pre_deployment_steps': {'key': 'preDeploymentSteps', 'type': '[PrePostStep]'},
        'deployment_target_id': {'key': 'deploymentTargetId', 'type': 'str'},
        'post_deployment_steps': {'key': 'postDeploymentSteps', 'type': '[PrePostStep]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StepGroup, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.depends_on_step_groups = kwargs.get('depends_on_step_groups', None)
        self.pre_deployment_steps = kwargs.get('pre_deployment_steps', None)
        self.deployment_target_id = kwargs['deployment_target_id']
        self.post_deployment_steps = kwargs.get('post_deployment_steps', None)


class StepOperationInfo(msrest.serialization.Model):
    """Detailed information of a specific step run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar deployment_name: The name of the ARM deployment initiated as part of the step.
    :vartype deployment_name: str
    :ivar correlation_id: Unique identifier to track the request for ARM-based resources.
    :vartype correlation_id: str
    :ivar start_time: Start time of the action in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the action in UTC.
    :vartype end_time: ~datetime.datetime
    :ivar last_updated_time: Last time in UTC this operation was updated.
    :vartype last_updated_time: ~datetime.datetime
    :param error: The errors, if any, for the action.
    :type error: ~azure.mgmt.deploymentmanager.models.CloudErrorBody
    """

    _validation = {
        'deployment_name': {'readonly': True},
        'correlation_id': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StepOperationInfo, self).__init__(**kwargs)
        self.deployment_name = None
        self.correlation_id = None
        self.start_time = None
        self.end_time = None
        self.last_updated_time = None
        self.error = kwargs.get('error', None)


class StepResource(TrackedResource):
    """The resource representation of a rollout step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param properties: Required. The properties that define the step.
    :type properties: ~azure.mgmt.deploymentmanager.models.StepProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'StepProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StepResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class WaitStepAttributes(msrest.serialization.Model):
    """The parameters for the wait step.

    All required parameters must be populated in order to send to Azure.

    :param duration: Required. The duration in ISO 8601 format of how long the wait should be.
    :type duration: str
    """

    _validation = {
        'duration': {'required': True},
    }

    _attribute_map = {
        'duration': {'key': 'duration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WaitStepAttributes, self).__init__(**kwargs)
        self.duration = kwargs['duration']


class WaitStepProperties(StepProperties):
    """Defines the properties of a Wait step.

    All required parameters must be populated in order to send to Azure.

    :param step_type: Required. The type of step.Constant filled by server.  Possible values
     include: "Wait", "HealthCheck".
    :type step_type: str or ~azure.mgmt.deploymentmanager.models.StepType
    :param attributes: Required. The Wait attributes.
    :type attributes: ~azure.mgmt.deploymentmanager.models.WaitStepAttributes
    """

    _validation = {
        'step_type': {'required': True},
        'attributes': {'required': True},
    }

    _attribute_map = {
        'step_type': {'key': 'stepType', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'WaitStepAttributes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WaitStepProperties, self).__init__(**kwargs)
        self.step_type = 'Wait'  # type: str
        self.attributes = kwargs['attributes']
