/*
 * $Id: searchform.c,v 1.21 2001/10/27 18:56:41 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "debug.h"
#include "document.h"
#include "prefsdata.h"
#include "resourceids.h"
#include "search.h"
#include "searchform.h"
#include "util.h"


/***********************************************************************
 *
 *      Internal Constants
 *
 ***********************************************************************/
#define START_AT_TOP true


/***********************************************************************
 *
 *      Private variables
 *
 ***********************************************************************/
static FieldType*   fldPtr;
static Boolean      searchInAllPages;



/* Initialize the search form */
static void SearchFormInit( void )
{
    FormType*       searchForm;
    ListType*       list;
    ControlType*    ctl;
    UInt16          selection;
    Char            text[ 16 ];

    fldPtr = (FieldType*) GetObjectPtr( frmSearchField );
    FldSetSelection( fldPtr, 0, 0 );
    GetSearchString( text );
    if ( *text != '\0' ) {
        FldInsert( fldPtr, text, StrLen( text ) );
        FldSetSelection( fldPtr, 0, StrLen( text ) );
    }

    searchForm = FrmGetFormPtr( frmSearch );
    FrmDrawForm( searchForm );
    FrmSetFocus( searchForm, FrmGetObjectIndex( searchForm, frmSearchField ) );

    searchInAllPages = Prefs()->searchInAllPages;
    if ( searchInAllPages )
        selection = 1;
    else
        selection = 0;

    list    = (ListType*) GetObjectPtr( frmSearchList );
    ctl     = (ControlType*) GetObjectPtr( frmSearchPopup );

    LstSetSelection( list, selection );
    CtlSetLabel( ctl, LstGetSelectionText( list, selection ) );

    CtlSetValue( (ControlType*) GetObjectPtr( frmSearchCaseless ), Prefs()->caseSensitive );
}



/* Event handler for the search form */
Boolean SearchFormHandleEvent
    (
    const EventType* event  /* pointer to an EventType structure */
    )
{
    Boolean   handled;
    Boolean   found;
    Char*     pattern;

    SET_A4_FROM_A5 

    handled = false;
    found   = false;
    pattern = NULL;

    switch ( event->eType ) {
        case ctlSelectEvent:
            if ( event->data.ctlEnter.controlID == frmSearchOK ) {
                Prefs()->caseSensitive      = CtlGetValue( (ControlType*) GetObjectPtr( frmSearchCaseless ) );
                Prefs()->searchInAllPages   = searchInAllPages;

                pattern = FldGetTextPtr( fldPtr );
                if ( pattern != NULL ) {
                    AddSearchString( pattern );

                    if ( ! searchInAllPages ) {
                        found = SearchInPage( pattern, START_AT_TOP );
                    }
                    else {
                        FrmGotoForm( frmResult );
                        handled = true;
                        break;
                    }
                }
            }
            else if ( event->data.ctlEnter.controlID == frmSearchHistory ) {
                MemHandle   nameListHandle;
                ListType*   list;
                Char**      nameList;
                Char*       patternList;
                Int16       selection;
                Int16       entries;

                entries = Prefs()->searchEntries;
                if ( entries == 0 ) {
                    FrmAlert( infoEmptyPatterns );
                    break;
                }

                patternList     = GetSearchPatterns();
                nameListHandle  = SysFormPointerArrayToStrings( patternList, entries );
                nameList        = (Char**) MemHandleLock( nameListHandle );
                list            = (ListType*) GetObjectPtr( frmSearchHistoryList );

                LstSetListChoices( list, nameList, entries );
                LstSetHeight( list, entries );

                selection = LstPopupList( list );
                if ( selection != noListSelection ) {
                    Char* pattern;
                    Char* label;

                    label   = LstGetSelectionText( list, selection );
                    pattern = FldGetTextPtr( fldPtr );
                    if ( pattern != NULL )
                        FldSetSelection( fldPtr, 0, StrLen( pattern ) );
                    FldInsert( fldPtr, label, StrLen( label ) );
                    FldSetSelection( fldPtr, 0, StrLen( label ) );
                }
                ReleaseSearchPatterns();
                MemHandleUnlock( nameListHandle );
                MemHandleFree( nameListHandle );
                break;
            }
            else if ( event->data.ctlEnter.controlID != frmSearchCancel )
                break;

            FrmReturnToForm( Prefs()->toolbar );
            if ( found )
                FrmUpdateForm( Prefs()->toolbar, frmShowResult );
            handled = true;
            break;

        case popSelectEvent:
            if ( event->data.popSelect.controlID == frmSearchPopup ) {
                Int16 selection;

                selection = event->data.popSelect.selection;
                if ( selection != noListSelection ) {
                    ListType*       list;
                    ControlType*    ctl;
                    Char*           label;

                    list    = event->data.popSelect.listP;
                    ctl     = (ControlType*) GetObjectPtr( frmSearchPopup );
                    label   = LstGetSelectionText( list, selection );

                    CtlSetLabel( ctl, label );
                    LstSetSelection( list, selection );
                    searchInAllPages = ( selection == 1 );
                }
                handled = true;
            }
            break;

        case frmOpenEvent:
            SearchFormInit();
            handled = true;
            break;

        case frmCloseEvent:
            handled = false;
            break;

        default:
            handled = false;
    }

    RESTORE_A4 

    return handled;
}
