/*
 * $Id: bookmarkform.c,v 1.15 2001/10/27 18:56:41 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "bookmark.h"
#include "bookmarkform.h"
#include "debug.h"
#include "prefsdata.h"
#include "resourceids.h"
#include "util.h"


Int16 GetBookmarkRecordID( void ) PLKRDB_SECTION;

static void AddBookmarkFormInit( void ) PLKRDB_SECTION;
static void BookmarksFormInit( void ) PLKRDB_SECTION;


/***********************************************************************
 *
 *      Internal Constants
 *
 ***********************************************************************/
#define DELETE_BOOKMARK         0
#define MAX_BOOKMARK_LIST_LEN   11


/***********************************************************************
 *
 *      Private variables
 *
 ***********************************************************************/
static FieldType*   fldPtr  = NULL;
static Int16        record  = NOT_FOUND;



/* Initialize the add bookmark form */
static void AddBookmarkFormInit( void )
{
    FormType* addBookmarkForm;

    addBookmarkForm = FrmGetFormPtr( frmAddBookmark );
    fldPtr          = (FieldType*) GetObjectPtr( frmAddBookmarkName );

    FrmDrawForm( addBookmarkForm );
    FrmSetFocus( addBookmarkForm, FrmGetObjectIndex( addBookmarkForm, frmAddBookmarkName ) );
}



/* Event handler for the add bookmark form */
Boolean AddBookmarkFormHandleEvent
    (
    const EventType* event  /* pointer to an EventType structure */
    )
{
    Boolean handled = false;

    SET_A4_FROM_A5 

    switch ( event->eType ) {
        case frmOpenEvent:
            AddBookmarkFormInit();
            handled = true;
            break;

        case frmCloseEvent:
            handled = false;
            break;

        case ctlSelectEvent:
            if ( event->data.ctlEnter.controlID == frmAddBookmarkAdd ) {
                if ( FldDirty( fldPtr ) ) {
                    Char* name = FldGetTextPtr( fldPtr );
                    if ( *name != '\0' )
                        AddBookmark( name );
                }
            }
            else if ( event->data.ctlEnter.controlID != frmAddBookmarkCancel )
                break;

            FrmReturnToForm( Prefs()->toolbar );
            handled = true;
            break;

        default:
            handled = false;
    }

    RESTORE_A4 

    return handled;
}



/* Return record ID for selected bookmark */
Int16 GetBookmarkRecordID( void )
{
    return record;
}



/* Initialize the bookmark form */
static void BookmarksFormInit( void )
{
    FormType* bookmarksForm;
    ListType* list;

    bookmarksForm = FrmGetFormPtr( frmBookmarks );

    list = (ListType*) GetObjectPtr( frmBookmarksList );
    CreateBookmarkList( list );
    LstSetHeight( list, MAX_BOOKMARK_LIST_LEN );

    FrmDrawForm( bookmarksForm );
}



/* Event handler for the bookmark form */
Boolean BookmarksFormHandleEvent
    (
    const EventType* event  /* pointer to an EventType structure */
    )
{
    Boolean handled = false;

    SET_A4_FROM_A5 

    record = NOT_FOUND;

    switch ( event->eType ) {
        case frmOpenEvent:
            BookmarksFormInit();
            handled = true;
            break;

        case frmCloseEvent:
            ReleaseBookmarkList();
            handled = false;
            break;

        case ctlSelectEvent:
            if ( event->data.ctlEnter.controlID == frmBookmarksDelete ) {
                ListType*   list;
                Int16       selection;

                list        = (ListType*) GetObjectPtr( frmBookmarksList );
                selection   = LstGetSelection( list );
                if ( selection != noListSelection ) {
                    UInt16 choice;

                    choice = FrmCustomAlert( confirmDelete, 
                                LstGetSelectionText( list, selection ), NULL, NULL );
                    if ( choice == DELETE_BOOKMARK ) {
                        Boolean emptyList;

                        emptyList = DeleteBookmark( selection );
                        if ( ! emptyList )
                            ReleaseBookmarkList();
                        CreateBookmarkList( list );
                        LstSetHeight( list, MAX_BOOKMARK_LIST_LEN );
                        LstDrawList( list );
                    }
                }
                break;
            }
            else if ( event->data.ctlEnter.controlID == frmBookmarksGo ) {
                ListType*   list;
                Int16       selection;

                list        = (ListType*) GetObjectPtr( frmBookmarksList );
                selection   = LstGetSelection( list );
                if ( selection != noListSelection ) {
                    record = RestoreBookmarkData( selection + 2 );
                }
            }
            else if ( event->data.ctlEnter.controlID != frmBookmarksDone )
                break;

            ReleaseBookmarkList();
            FrmReturnToForm( Prefs()->toolbar );
            if ( record != NOT_FOUND ) {
                FrmUpdateForm( Prefs()->toolbar, frmViewRecord );
            }
            handled = true;
            break;

        default:
            handled = false;
    }

    RESTORE_A4 

    return handled;
}
