/*
 * $Id: anchor.h,v 1.20 2001/07/18 20:01:35 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_ANCHOR_H
#define __PLUCKER_ANCHOR_H

#include "viewer.h"
#include "util.h"


typedef enum {
    ANCHOR_UNUSED       = 0,
    ANCHOR_SELECTED     = 1,
    ANCHOR_UNSELECTED   = 2,
    ANCHOR_LIMBO        = 3
} AnchorStateType;


Int16 FindVisibleAnchor( const Int16 x, const Int16 y );
Int16 GetVisibleImage( const Int16 index );
Int16 GetVisibleOffset( const Int16 index );
Int16 GetVisibleReference( const Int16 index );
RectangleType GetVisibleImagePosition( const Int16 index );
void AddImageAnchor( const TextContext* tContext, const Int16 height,
        const Int16 image );
void AdjustVisibleAnchors( const Int16 adjustment );
void ClearVisibleAnchors( void );
void ContinueAnchor( const TextContext* tContext );
void HighlightAnchor( const Int16 control, const AnchorStateType state );
void RestartAnchor( const TextContext* tContext, const Int16 height );
void StartAnchor( const TextContext* tContext, const Int16 reference,
        const Int16 offset, const Int16 image );
void StopAnchor( const TextContext* tContext, const Int16 height );
void StopImageAnchor( TextContext* tContext, const Int16 height,
        const Int16 width );

#endif
