/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/

#include "ee_thumb.h"
#include "ee_file.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

void
ee_thumb_init_dirs(void)
{
	gchar               *hom;
	gchar               *s;

	hom = homedir(getuid());
	if (!hom)
		return;
	s = g_strconcat(hom, "/.ee/icons/", NULL);
	if (!exists(s))
		mkdirs(s);
	g_free(s);
	s = g_strconcat(hom, "/.ee/minis/", NULL);
	if (!exists(s))
		mkdirs(s);
	g_free(s);
	g_free(hom);
}

GdkImlibImage *
ee_thumb_find(gchar *path, gchar *filename, gchar *size, gint maxw, gint maxh)
{
	gchar               *hom;
	gchar               *s;
	gint                 w, h;
	GdkImlibImage       *im, *im2;
	gchar				*file;

	file = g_strconcat(path, "/", filename, NULL);

	s = g_strconcat(path, "/.", size, "/", filename, NULL);
	if (!isfile(s))
	{
		g_free(s);
		hom = homedir(getuid());
		if (!hom)
			return NULL;

		s = g_strconcat(hom, "/.ee/", size, "/", file, NULL);
		g_free(hom);
	}

	if (isfile(s))
	{
		im = gdk_imlib_load_image(s);
		g_free(s);
		if (im)
		{
			return im;
		}
	}
	else
		g_free(s);

	if (isfile(file))
		im = gdk_imlib_load_image(file);

	if (!im)
	{
		return NULL;
	}
	h = maxh;
	w = (im->rgb_width * h) / im->rgb_height;
	if (w > maxw)
	{
		w = maxw;
		h = (im->rgb_height * w) / im->rgb_width;
	}
	im2 = gdk_imlib_clone_scaled_image(im, w, h);
	gdk_imlib_destroy_image(im);

	hom = homedir(getuid());
	if (!hom)
		return NULL;
	s = g_strconcat(hom, "/.ee/", size, "/", file, NULL);
	g_free(hom);
	mkdirs(s);
	gdk_imlib_save_image_to_ppm(im2, s);
	g_free(s);

	while (gtk_events_pending())
		gtk_main_iteration();

	return im2;
}
