/*
 * imagesource.h - base class for the efficient scanline-based
 * handling of extremely large images.
 *
 * Copyright (c) 2004 by Alastair M. Robinson
 * Distributed under the terms of the GNU General Public License -
 * see the file named "COPYING" for more details.
 *
 */

#ifndef IMAGESOURCE_H
#define IMAGESOURCE_H

#include <stdlib.h>

#include "imagesource_types.h"
#include "../profilemanager/lcmswrapper.h"

class ImageSource
{
	public:
	ImageSource() : embeddedprofile(NULL), rowbuffer(NULL)
	{
	}
	ImageSource(ImageSource *src) : rowbuffer(NULL)
	{
		width=src->width;
		height=src->height;
		type=src->type;
		samplesperpixel=src->samplesperpixel;
		xres=src->xres;
		yres=src->yres;
		randomaccess=src->randomaccess;
		embeddedprofile=src->embeddedprofile;
		currentrow=-1;
	}
	virtual ~ImageSource()
	{
		if(rowbuffer)
			free(rowbuffer);
	}
	virtual ISDataType *GetRow(int row)=0;
	void MakeRowBuffer()
	{
		rowbuffer=(ISDataType *)malloc(sizeof(ISDataType)*width*samplesperpixel);
		currentrow=-1;
	}
	void SetResolution(double xr,double yr)
	{
		xres=xr;
		yres=yr;
	}
	CMSProfile *GetEmbeddedProfile()
	{
		return(embeddedprofile);
	}
	void SetEmbeddedProfile(CMSProfile *profile)
	{
		if(embeddedprofile)
			delete embeddedprofile;
		embeddedprofile=profile;
	}
	int width,height;
	enum IS_TYPE type;
	int samplesperpixel;
	double xres,yres;
	bool randomaccess;
	protected:
	CMSProfile *embeddedprofile;
	int currentrow;
	ISDataType *rowbuffer;
};


#endif
