;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;



; l0-aprims.lisp

(defun %cstr-pointer (string pointer &optional script)
  (declare (ignore script))
  (if (base-string-p string)
    (multiple-value-bind (s o n) (dereference-base-string string)
      (declare (fixnum o n))
      (%copy-ivector-to-ptr s o pointer 0 n)
      (setf (%get-byte pointer n) 0)
      )
    (%put-cstring pointer string 0))
  nil)


 ; its also in l1-aprims
; from string to pointer - used by with-pstrs 

(defun %pstr-pointer (string pointer &optional script)  
  (if (> (length string) 255) (error "String ~s too long for pascal string." string))
  (if (base-string-p string)
    (multiple-value-bind (s o n) (dereference-base-string string)
      (declare (fixnum o n))
      (let* ((limit (min n 255)))
        (declare (fixnum limit))
        (setf (%get-byte pointer 0) limit) ; set length byte
        (%copy-ivector-to-ptr s o pointer 1 n)))
    (%put-string pointer string 0 255 script))
  nil)

; its also in l1-symhash
(defun dereference-base-string (s)
  (multiple-value-bind (vector offset) (array-data-and-offset s)
    (unless (typep vector 'simple-base-string) (report-bad-arg s 'base-string))
    (values vector offset (the fixnum (+ (the fixnum offset) (the fixnum (length s)))))))


; end
