;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


(eval-when (:compile-toplevel :execute)
  (require "SPARC-ARCH")
  (require "SPARC-LAPMACROS"))




; Assumptions made by %init-misc
(eval-when (:compile-toplevel :execute)
  (assert (and (< arch::max-32-bit-ivector-subtag
                  arch::max-8-bit-ivector-subtag
                  arch::max-16-bit-ivector-subtag)
               (eql arch::max-32-bit-ivector-subtag arch::subtag-s32-vector)
               (eql arch::max-16-bit-ivector-subtag arch::subtag-s16-vector)
               (eql arch::max-8-bit-ivector-subtag arch::subtag-simple-base-string))))

(defsparclapfunction %init-misc ((val %arg_y)
				(miscobj %arg_z))
  (getvheader miscobj %imm0)
  (header-size %imm0 %imm3)
  (tst %imm3)
  (be @done)               ; Silly 0-length case
    (extract-fulltag %imm0 %imm1)
  (cmp %imm1 arch::fulltag-nodeheader)
  (mov arch::misc-data-offset %imm4)
  (bne.a @imm)
    (extract-lowbyte %imm0 %imm2)

  ; Node vector.  Don't need to memoize, since initial value is
  ; older than vector.
  @node-loop
  (deccc %imm3)
  (st val (miscobj %imm4))
  (bne @node-loop)
   (inc 4 %imm4)
  @done
  (retl)
   (nop)
  @imm
  (extract-typecode val %imm1)
  (cmp %imm2 arch::subtag-double-float-vector)
  (be @dfloat)
    (cmp %imm2 arch::max-32-bit-ivector-subtag)
  (ble @32)
    (cmp %imm2 arch::max-8-bit-ivector-subtag)
  (ble @8)
    (cmp %imm2 arch::max-16-bit-ivector-subtag)
  (ble @16)
    (cmp val '1)
  ; Bit vector
  (inc 31 %imm3)
  (srl %imm3 5 %imm3)
  (unbox-fixnum val %imm0)
  (bleu @set-32)
    (sub %rzero %imm0 %imm0)
  @bad
  (mov '#.$xnotelt %arg_x)
  (save-lisp-context)
  (call-symbol %err-disp)
   (set-nargs 3)
  @dfloat
  (cmp %imm1 arch::subtag-double-float)
  (bne @bad)
    (mov arch::misc-data-offset %imm4)
  (lddf (val arch::double-float.value) %f2)
  @dfloat-loop
  (deccc %imm3)
  (stdf %f2 (miscobj %imm4))
  (bne @dfloat-loop)
    (inc arch::double-float.size %imm4)
  (retl)
   (nop)
  @32
  (cmp %imm2 arch::subtag-single-float-vector)
  (be.a @sfloat)
    (cmp %imm0 arch::subtag-single-float)
  (cmp %imm2 arch::subtag-u32-vector)
  (be @s32)
    (nop)
  @u32
  (extract-unsigned-byte-bits. val 30 %imm0)
  (be.a @set-32)
    (unbox-fixnum val %imm0)
  (cmp %imm1 arch::subtag-bignum)
  (bne @bad)
    (nop)
  (getvheader val %imm1)
  (cmp %imm1 arch::two-digit-bignum-header)
  (bgu @bad)
  (ld (val arch::misc-data-offset) %imm0)
  (be @two-digits)
    (tst %imm0)
  (bg @set-32)
    (nop)
  (b @bad)
    (nop)
  @two-digits
  (ld (val (+ 4 arch::misc-data-offset)) %imm1)
  (tst %imm1)
  (bne @bad)
    (nop)
  (b @set-32)
    (nop)
  @sfloat
  (be.a @set-32)
    (ld (val arch::single-float.value) %imm0)
  (b @bad)
   (nop)
  @s32
  (cmp %imm1 arch::tag-fixnum)
  (be.a @set-32)
   (unbox-fixnum val %imm0)
  (cmp %imm1 arch::subtag-bignum)
  (bne @bad)
    (nop)
  (getvheader val %imm0)
  (cmp %imm0 arch::one-digit-bignum-header)
  (be.a @set-32)
    (ld (val arch::misc-data-offset) %imm0)
  (b @bad)
    (nop)
  @16
  (cmp %imm2 arch::subtag-s16-vector)
  (inc %imm3)
  (srl %imm3 1 %imm3)
  (be @s16)
    (cmp %imm2 arch::subtag-simple-general-string)
  (be @char16)
    (nop)
  @u16
  (extract-unsigned-byte-bits. val 16 %imm0)
  (be @set-16)
    (unbox-fixnum val %imm0)
  (b @bad)
    (nop)
  @s16
  (cmp %imm1 arch::tag-fixnum)
  (bne @bad)
    (sll val (- 32 (+ 16 arch::fixnumshift)) %imm0)
  (sra %imm0 (- 32 (+ 16 arch::fixnumshift)) %imm0)
  (cmp %imm0 val)
  (be @set-16)
    (unbox-fixnum val %imm0)
  (b @bad)
    (nop)
  @char16
  (extract-lowbyte val %imm0)
  (cmp %imm0 arch::subtag-character)
  (be @set-16)
    (srl val arch::charcode-shift %imm0)
  (b @bad)
    (nop)
  @8
  (cmp %imm2 arch::subtag-simple-base-string)
  (inc 3 %imm3)
  (srl %imm3 2 %imm3)
  (be @char8)
    (cmp %imm2 arch::subtag-s8-vector)
  (be @s8)
    (extract-unsigned-byte-bits. val 8 %imm0)
  (be @set-8)
    (unbox-fixnum val %imm0)
  (b @bad)
    (nop)
  @s8
  (cmp %imm1 arch::tag-fixnum)
  (bne @bad)
    (sll val (- 32 (+ 8 arch::fixnumshift)) %imm0)
  (sra %imm0 (- 32 (+ 8 arch::fixnumshift)) %imm0)
  (cmp val %imm0)
  (be @set-8)
    (unbox-fixnum val %imm0)
  (b @bad)
    (nop)
  @char8
  (extract-lowbyte val %imm0)
  (cmp %imm0 arch::subtag-character)
  (bne @bad)
    (unbox-base-char val %imm0)
  @set-8                                ; propagate low 8 bits into low 16
  (sll %imm0 8 %imm1)
  (or %imm0 %imm1 %imm0)
  @set-16                               ; propagate low 16 bits into high 16
  (sll %imm0 16 %imm1)
  (or %imm1 %imm0 %imm0)
  @set-32
  (deccc %imm3)
  (st %imm0 (miscobj %imm4))
  (bne @set-32)
    (inc 4 %imm4)
  (retl)
    (nop))

; Make a new vector of size newsize whose subtag matches that of oldv-arg.
; Blast the contents of the old vector into the new one as quickly as
; possible; leave remaining elements of new vector undefined (0).
; Return new-vector.
(defsparclapfunction %extend-vector ((start-arg %arg_x) (oldv-arg %arg_y) (newsize %arg_z))
  (let ((oldv %save0)
        (oldsize %save1)
        (oldsubtag %save2)
        (start-offset %save3))
    (save-lisp-context)
    (vpush %save0)
    (vpush %save1)
    (vpush %save2)
    (vpush %save3)
    (mov oldv-arg oldv)
    (mov start-arg start-offset)
    (getvheader oldv %imm0)
    (header-length %imm0 oldsize)
    (header-subtag[fixnum] %imm0 oldsubtag)
    (mov newsize %arg_y)
    (call-subprim .SPmisc-alloc)
      (mov oldsubtag %arg_z)
    (unbox-fixnum oldsubtag %imm0)
    (extract-fulltag %imm0 %imm0)
    
    (add start-offset arch::misc-data-offset %imm1)
    (mov arch::misc-data-offset %imm3)
    (tst oldsize)
    (be @done)
      (cmp %imm0 arch::fulltag-nodeheader)
    (bne.a @imm)
      (cmp oldsubtag '#.arch::max-32-bit-ivector-subtag)
    ; copy nodes.  New vector is "new", so no memoization required.
    @node-loop
    (deccc '1 oldsize)
    (ld (oldv %imm1) %temp0)
    (inc 4 %imm1)
    (st %temp0 (%arg_z %imm3))
    (bne @node-loop)
      (inc 4 %imm3)
    ;Restore registers.  New vector's been in %arg_z all this time.
    @done
    (ld (%vsp 0) %save3)
    (ld (%vsp 4) %save2)
    (ld (%vsp 8) %save1)
    (ld (%vsp 12) %save0)
    (restore-full-lisp-context)
    (retl)
    @imm
    (unbox-fixnum oldsize %imm2)
    (unbox-fixnum start-offset %imm3)
    (mov arch::misc-data-offset %imm1)
    (add start-offset arch::misc-data-offset %imm4)
    (ble @fullword-loop)
      (cmp oldsubtag '#.arch::max-8-bit-ivector-subtag)
    (ble @8-bit)
      (cmp oldsubtag '#.arch::max-16-bit-ivector-subtag)
    (ble @16-bit)
      (cmp oldsubtag '#.arch::subtag-bit-vector)
    (be @1-bit)
      (nop)
    ; 64-bit (double-float) vectors.  There's a different
    ; initial offset, but we're always word-aligned, so that
    ; part's easy.
    (mov arch::misc-dfloat-offset %imm1)   ; scaled destination pointer
    (sll %imm2 1 %imm2)			; twice as many fullwords
    (sll %imm3 3 %imm3)                  ; convert dword count to byte offset
    (b @fullword-loop)    
      (add %imm3 arch::misc-dfloat-offset %imm4)      ; scaled source pointer

    ; The bitvector case is hard if START-OFFSET isn't on an 8-bit boundary,
    ;  and can be turned into the 8-bit case otherwise.
    ; The 8-bit case is hard if START-OFFSET isn't on a 16-bit boundary, 
    ;  and can be turned into the 16-bit case otherwise.
    ; The 16-bit case is hard if START-OFFSET isn't on a 32-bit boundary, 
    ;  and can be turned into the 32-bit case otherwise.
    ; Hmm.
    @1-bit
    (andcc %imm3 7 %rzero)
    (bne @hard-1-bit)
      (srl %imm3 3 %imm3)                  ; bit offset to byte offset
    (inc 7 %imm2)
    (srl %imm2 3 %imm2)                  ; bit count to byte count
    @8-bit
    ; If the byte offset's even, copy half as many halfwords
    (andcc %imm3 1 %rzero) 
    (bne @hard-8-bit)
      (inc %imm2)
    (srl %imm2 1 %imm2)                  ; byte count to halfword count
    (srl %imm3 1 %imm3)                  ; byte offset to halfword offset
    @16-bit
    ; If the halfword offset's even, copy half as many fullwords
    (andcc %imm3 1 %rzero)
    (bne @hard-16-bit)
      (inc %imm2)
    (srl %imm2 1 %imm2)                  ; halfword count to fullword count
    (mov arch::misc-data-offset %imm1)
    @fullword-loop
    (deccc %imm2)
    (ld (oldv %imm4) %imm0)
    (inc 4 %imm4)
    (st %imm0 (%arg_z %imm1))    
    (bne @fullword-loop)
      (inc 4 %imm1)
    (b @done)
      (nop)
    ;;; This can just do a uvref/uvset loop.  Cases that can
    ;;; cons (x32, double-float) have already been dealt with.
    @hard-1-bit
    @hard-8-bit
    @hard-16-bit
    (let ((newv %save3)
          (outi %save4))
      (vpush %save3)
      (vpush %save4)
      (mov %arg_z newv)
      (mov 0 outi)
      @hard-loop
      (mov oldv %arg_y)
      (call-subprim .SPmisc-ref)
        (mov start-offset %arg_z)
      (mov newv %arg_x)
      (call-subprim .SPmisc-set)
        (mov outi %arg_y)
      (inc '1 outi)
      (cmp outi oldsize)
      (bne @hard-loop)
        (inc '1 start-offset)
      (mov newv %arg_z)
      (vpop %save4)
      (vpop %save3)
      (b @done)
        (nop))))


;; argument is a vector header or an array header.  Or else.
(defsparclapfunction %array-header-data-and-offset ((a %arg_z))
  (let ((offset %arg_y)
        (disp %arg_x)
        (temp %temp0))
    (mov 0 offset)
    (mov a temp)
    @loop
    (ld (temp arch::arrayH.data-vector) a)
    (extract-subtag a %imm0)
    (cmp %imm0 arch::subtag-vectorH)
    (ld (temp arch::arrayH.displacement) disp)
    (mov a temp)
    (ble @loop)
      (inc disp offset)
    (vpush a)
    (vpush offset)
    (set-nargs 2)
    (jump-subprim .SPvalues)
    (add %vsp 8 %temp0)))

