;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 2001 Clozure Associates
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

(in-package "CCL")

(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "SYSCALL"))







(define-syscall os::exit 1 (:signed-fullword) :void)
(define-syscall os::fork 2 () :signed-fullword)
(define-syscall os::read 3 (:unsigned-fullword :address :unsigned-fullword)
		:signed-fullword)
(define-syscall os::write 4 (:unsigned-fullword :address :unsigned-fullword)
		:signed-fullword)
(define-syscall os::open 5 (:address :unsigned-fullword :unsigned-fullword) :signed-fullword :min-args 2)
(define-syscall os::close 6 (:unsigned-fullword) :signed-fullword )
(define-syscall os::waitpid 7 (:unsigned-fullword :address :signed-fullword)
		:signed-fullword)
(define-syscall os::creat 8 (:address :unsigned-fullword) :signed-fullword )
(define-syscall os::link 9 (:address :address) :signed-fullword)
(define-syscall os::unlink 10 (:address) :signed-fullword )
(define-syscall os::execve 11 (:address :address :address) :signed-fullword )
(define-syscall os::chdir 12 (:address) :signed-fullword )
(define-syscall os::time 13 (:address) :unsigned-fullword )
(define-syscall os::mknod 14 (:address :unsigned-fullword :unsigned-fullword)
		:signed-fullword)
(define-syscall os::chmod 15 (:address :unsigned-fullword) :signed-fullword)
(define-syscall os::lchown 16 (:address :unsigned-fullword :unsigned-fullword)
		:signed-fullword)
;(define-syscall os::oldstat 18 () )
(define-syscall os::lseek 19 (:unsigned-fullword :signed-fullword :unsigned-fullword) :signed-fullword )
(define-syscall os::getpid 20 () :unsigned-fullword)
(define-syscall os::mount 21 (:address
				 :address
				 :address
				 :unsigned-fullword
				 :address) :signed-fullword )
(define-syscall os::umount 22 (:address) :signed-fullword )

(define-syscall os::setuid 23 (:unsigned-fullword) :signed-fullword )
(define-syscall os::getuid 24 () :unsigned-fullword )
(define-syscall os::stime 25 (:address) :signed-fullword )
(define-syscall os::ptrace 26 (:unsigned-fullword
				  :unsigned-fullword
				  :address
				  :address)
		:signed-fullword)
(define-syscall os::alarm 27 (:unsigned-fullword) :unsigned-fullword )

(define-syscall os::pause 29 () :signed-fullword)
(define-syscall os::utime 30 (:address :address) :signed-fullword )
(define-syscall os::access 33 (:address :unsigned-fullword) :signed-fullword)
(define-syscall os::nice 34 (:signed-fullword) :signed-fullword )
(define-syscall os::sync 36 () :unsigned-fullword )
(define-syscall os::kill 37 (:signed-fullword :unsigned-fullword) :signed-fullword )
(define-syscall os::rename 38 (:address :address) :signed-fullword )
(define-syscall os::mkdir 39 (:address :unsigned-fullword) :signed-fullword )
(define-syscall os::rmdir 40 (:address) :signed-fullword )
(define-syscall os::dup 41 (:unsigned-fullword) :signed-fullword )
(define-syscall os::pipe 42 (:address) :signed-fullword )
(define-syscall os::times 43 (:address) :unsigned-fullword )

(define-syscall os::brk 45 (:address) :signed-fullword )
(define-syscall os::setgid 46 (:unsigned-fullword) :signed-fullword)
(define-syscall os::getgid 47 () :unsigned-fullword )
(define-syscall os::signal 48 (:unsigned-fullword :address) :address )
(define-syscall os::geteuid 49 () :unsigned-fullword )
(define-syscall os::getegid 50 () :unsigned-fullword)
(define-syscall os::acct 51 (:address) :signed-fullword )
(define-syscall os::umount2 52 (:address) :signed-fullword )
(define-syscall os::ioctl 54 (:unsigned-fullword :signed-fullword :address) :signed-fullword :min-args 2 )
(define-syscall os::fcntl 55 (:unsigned-fullword :signed-fullword :signed-fullword) :signed-fullword :min-args 2 )
(define-syscall os::setpgid 57 (:signed-fullword :signed-fullword) :signed-fullword )
(define-syscall os::umask 60 (:unsigned-fullword) :unsigned-fullword )
(define-syscall os::chroot 61 (:address) :signed-fullword )
(define-syscall os::ustat 62 (:unsigned-fullword :address) :signed-fullword )
(define-syscall os::dup2 63 (:unsigned-fullword :unsigned-fullword) :signed-fullword )
(define-syscall os::getppid 64 () :unsigned-fullword)
(define-syscall os::getpgrp 65 () :unsigned-fullword)
(define-syscall os::setsid 66 () :signed-fullword)
(define-syscall os::sigaction 67 (:unsigned-fullword :address :address) :signed-fullword )
(define-syscall os::getrusage 77 (:signed-fullword :address) :signed-fullword)
(define-syscall os::gettimeofday 78 (:address :address) :void)
(define-syscall os::ftruncate 93 (:unsigned-fullword :unsigned-fullword)
		:signed-fullword)
(define-syscall os::fchmod 94 (:unsigned-fullword :unsigned-fullword)
		:signed-fullword )
(define-syscall os::socketcall 102 (:unsigned-fullword :address) :signed-fullword )
(define-syscall os::stat 106 (:address :address) :signed-fullword)
(define-syscall os::lstat 107 (:address :address) :signed-fullword)
(define-syscall os::fstat 108 (:unsigned-fullword :address) :signed-fullword )

(define-syscall os::fsync 118 (:unsigned-fullword) :signed-fullword )
(define-syscall os::uname 122  (:address) :signed-fullword)
(define-syscall os::fchdir 133 (:unsigned-fullword) :signed-fullword )
(define-syscall os::_llseek 140 (:unsigned-fullword :unsigned-fullword :unsigned-fullword :address :unsigned-fullword) :signed-fullword )
(define-syscall os::getcwd 182 (:address :unsigned-fullword) :signed-fullword )



#+notdefinedyet
(progn
(define-syscall os::sgetmask 68 () )
(define-syscall os::ssetmask 69 () )
(define-syscall os::setreuid 70 () )
(define-syscall os::setregid 71 () )
(define-syscall os::sigsuspend 72 () )
(define-syscall os::sigpending 73 () )
(define-syscall os::sethostname 74 () )
(define-syscall os::setrlimit 75 () )
(define-syscall os::getrlimit 76 () )
(define-syscall os::settimeofday 79 () )
(define-syscall os::getgroups 80 () )
(define-syscall os::setgroups 81 () )
(define-syscall os::select 82 () )
(define-syscall os::symlink 83 () )
(define-syscall os::oldlstat 84 () )
(define-syscall os::readlink 85 () )
(define-syscall os::uselib 86 () )
(define-syscall os::swapon 87 () )
(define-syscall os::reboot 88 () )
(define-syscall os::readdir 89 () )
(define-syscall os::mmap 90 () )
(define-syscall os::munmap 91 () )
(define-syscall os::truncate 92 () )

(define-syscall os::fchown 95 () )
(define-syscall os::getpriority 96 () )
(define-syscall os::setpriority 97 () )
(define-syscall os::statfs 99 () )
(define-syscall os::fstatfs 100 () )
(define-syscall os::ioperm 101 () )
(define-syscall os::syslog 103 () )
(define-syscall os::setitimer 104 () )
(define-syscall os::getitimer 105 () )
(define-syscall os::olduname 109 () )
(define-syscall os::iopl 110 () )
(define-syscall os::vhangup 111 () )
(define-syscall os::idle 112 () )
(define-syscall os::vm86 113 () )
(define-syscall os::wait4 114 () )
(define-syscall os::swapoff 115 () )
(define-syscall os::sysinfo 116 () )
(define-syscall os::ipc 117 () )
(define-syscall os::sigreturn 119 () )
(define-syscall os::clone 120 () )
(define-syscall os::setdomainname 121 () )
(define-syscall os::modify_ldt 123 () )
(define-syscall os::adjtimex 124 () )
(define-syscall os::mprotect 125 () )
(define-syscall os::sigprocmask 126 () )
(define-syscall os::create_module	127 () )
(define-syscall os::init_module	128 () )
(define-syscall os::delete_module	129 () )
(define-syscall os::get_kernel_syms	130 () )
(define-syscall os::quotactl 131 () )
(define-syscall os::getpgid 132 () )
(define-syscall os::bdflush 134 () )
(define-syscall os::sysfs 135 () )
(define-syscall os::personality 136 () )
(define-syscall os::setfsuid 138 () )
(define-syscall os::setfsgid 139 () )
(define-syscall os::getdents 141 () )
(define-syscall os::_newselect 142 () )
(define-syscall os::flock 143 () )
(define-syscall os::msync 144 () )
(define-syscall os::readv 145 () )
(define-syscall os::writev 146 () )
(define-syscall os::getsid 147 () )
(define-syscall os::fdatasync 148 () )
(define-syscall os::_sysctl 149 () )
(define-syscall os::mlock 150 () )
(define-syscall os::munlock 151 () )
(define-syscall os::mlockall 152 () )
(define-syscall os::munlockall 153 () )
(define-syscall os::sched_setparam 154 () )
(define-syscall os::sched_getparam 155 () )
(define-syscall os::sched_setscheduler 156 () )
(define-syscall os::sched_getscheduler 157 () )
(define-syscall os::sched_yield 158 () )
(define-syscall os::sched_get_priority_max 159 () )
(define-syscall os::sched_get_priority_min 160 () )
(define-syscall os::sched_rr_get_interval 161 () )
(define-syscall os::nanosleep 162 () )
(define-syscall os::mremap 163 () )
(define-syscall os::setresuid 164 () )
(define-syscall os::getresuid 165 () )
(define-syscall os::query_module	166 () )
(define-syscall os::poll 167 () )
(define-syscall os::nfsservctl 168 () )
(define-syscall os::setresgid 169 () )
(define-syscall os::getresgid 170 () )
(define-syscall os::prctl 171 () )
(define-syscall os::rt_sigreturn 172 () )
(define-syscall os::rt_sigaction 173 () )
(define-syscall os::rt_sigprocmask 174 () )
(define-syscall os::rt_sigpending 175 () )
(define-syscall os::rt_sigtimedwait 176 () )
(define-syscall os::rt_sigqueueinfo 177 () )
(define-syscall os::rt_sigsuspend 178 () )
(define-syscall os::pread 179 () )
(define-syscall os::pwrite 180 () )
(define-syscall os::chown 181 (:address) )

(define-syscall os::capget 183 () )
(define-syscall os::capset 184 () )
(define-syscall os::sigaltstack 185 () )
(define-syscall os::sendfile 186 () )
(define-syscall os::getpmsg 187	 () )
(define-syscall os::putpmsg 188	 () )
(define-syscall os::vfork 189 () )

)