Name: OpenIPMI
Summary: %{name} - Library interface to IPMI
Version: 2.0.7
Release: 2
License: LGPL
URL: http://openipmi.sourceforge.net
Group: Utilities
Vendor: OpenIPMI Project
Packager: Tariq Shureih <tariq.shureih@intel.com>
Source: %{name}-2.0.7.tar.gz
Buildroot: /var/tmp/%{name}-root
BuildRequires: pkgconfig, perl >= 5, swig >= 1.3
Summary: IPMI Library
Group: Utilities

# Perl is usually installed in /usr/lib, not /usr/lib64 on 64-bit platforms.
%define perl_libdir %{_exec_prefix}/lib

%description 
This package contains a shared library implementation of IPMI and the
basic tools used with OpenIPMI.

%package devel
Summary: Development files for OpenIPMI
Group: Utilities
Requires: OpenIPMI = %{version}, pkgconfig

%description devel
Contains additional files need for a developer to create applications
and/or middleware that depends on libOpenIPMI

%package perl
Summary: Perl interface for OpenIPMI
Group: Utilities
Requires: OpenIPMI = %{version}, perl >= 5

%description perl
A Perl interface for OpenIPMI.

%package python
Summary: Python interface for OpenIPMI
Group: Utilities
Requires: OpenIPMI = %{version}, python

%description python
A Python interface for OpenIPMI.

%package gui
Summary: GUI (in python) for OpenIPMI
Group: Utilities
Requires: OpenIPMI-python = %{version}, tkinter

%description gui
A GUI interface for OpenIPMI.  Written in python an requiring wxWidgets.

%package ui
Summary: User Interface (ui)
Group: Utilities
Requires: OpenIPMI = %{version}

%description ui
This package contains a user interface

%package lanserv
Summary: Emulates an IPMI network listener
Group: Utilities
Requires: OpenIPMI = %{version}

%description lanserv
This package contains a network IPMI listener.

###################################################
%prep
###################################################
%setup

###################################################
%build
###################################################
%configure
make

###################################################
%install
###################################################
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install
install -d %{buildroot}/etc/init.d
install -d %{buildroot}/etc/sysconfig
install ipmi.init %{buildroot}/etc/init.d/ipmi
install ipmi.sysconf %{buildroot}/etc/sysconfig/ipmi

###################################################
%post
###################################################
chkconfig --add ipmi

###################################################
%preun
###################################################
if [ $1 = 0 ]; then
   /etc/init.d/ipmi stop >/dev/null 2>&1
   /sbin/chkconfig --del ipmi
fi

###################################################
%postun
###################################################
if [ "$1" -ge "1" ]; then
    /etc/init.d/ipmi condrestart >/dev/null 2>&1 || :
fi

###################################################
%files
###################################################
%defattr(-,root,root)
%{_libdir}/libOpenIPMIcmdlang.so.*
%{_libdir}/libOpenIPMIglib.so.*
%{_libdir}/libOpenIPMIglib12.so.*
%{_libdir}/libOpenIPMItcl.so.*
%{_libdir}/libOpenIPMIposix.so.*
%{_libdir}/libOpenIPMIpthread.so.*
%{_libdir}/libOpenIPMI.so.*
%{_libdir}/libOpenIPMIutils.so.*
%doc COPYING COPYING.LIB FAQ INSTALL README README.Force
%doc README.MotorolaMXP CONFIGURING_FOR_LAN COPYING.BSD
/etc/init.d/ipmi
/etc/sysconfig/ipmi


###################################################
%files perl
###################################################
%defattr(-,root,root)
%{perl_libdir}/perl5
%doc swig/OpenIPMI.i swig/perl/sample swig/perl/ipmi_powerctl

###################################################
%files python
###################################################
%defattr(-,root,root)
%{_libdir}/python*/site-packages/*OpenIPMI.*
%doc swig/OpenIPMI.i

###################################################
%files gui
###################################################
%defattr(-,root,root)
%dir %{_libdir}/python*/site-packages/openipmigui
%{_libdir}/python*/site-packages/openipmigui/*
%{_bindir}/openipmigui

###################################################
%files devel
###################################################
%defattr(-,root,root)
%{_includedir}/OpenIPMI
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig
%doc doc/IPMI.pdf

###################################################
%files ui
###################################################
%defattr(-,root,root)
%{_bindir}/ipmi_ui
%{_bindir}/ipmicmd
%{_bindir}/openipmicmd
%{_bindir}/ipmish
%{_bindir}/openipmish
%{_bindir}/solterm
%{_bindir}/rmcp_ping
%{_libdir}/libOpenIPMIui.so*
%{_libdir}/libOpenIPMIui.la
%doc %{_mandir}/man1/ipmi_ui.1*
%doc %{_mandir}/man1/openipmicmd.1*
%doc %{_mandir}/man1/openipmish.1*
%doc %{_mandir}/man1/openipmigui.1*
%doc %{_mandir}/man1/solterm.1*
%doc %{_mandir}/man1/rmcp_ping.1*
%doc %{_mandir}/man7/ipmi_cmdlang.7*
%doc %{_mandir}/man7/openipmi_conparms.7*

###################################################
%files lanserv
###################################################
%defattr(-,root,root)
%{_bindir}/ipmilan
%{_libdir}/libIPMIlanserv.so*
%{_libdir}/libIPMIlanserv.la
%doc %{_mandir}/man8/ipmilan.8*

