// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#ifndef PROP_HANDLE_H
#define PROP_HANDLE_H

#include <vector>
#include "property.h"
#include "object.h"


typedef std::vector<ocpl::Handle> HandleVectList ;

//! A vector of handles (actually implemented as a set)
class HandleVectNoOwn : public Property {
public:
  HandleVectNoOwn() {};
  HandleVectNoOwn(ocpl::Handle hnd) {Value.push_back(hnd);}
  ~HandleVectNoOwn() {_DEBUG_PRINT("In ~HVno\n");Clear();};
  HandleVectList* GetVal(void) {return &Value;}
  //! Add another handle
  virtual void Add(const ocpl::Handle new_handle);
  int Size() {return Value.size();}
  virtual void Clear() {Value.clear();}; //!< clears the list w/o deleteing objects
  virtual void Delete(const ocpl::Handle handle);
  void AllDraw(); //!< Calls draw() in all objects
  //! Gets First Handle (useful if length is 1)
  ocpl::Handle operator()(){First();return CurrentHandle();}
  //////// Iterator wrapper
  void First() {im = Value.begin();} //!< Iterator function
  void Next() {im++;} //!< Iterator function
  bool IsDone() {return im==Value.end();} //!< Iterator function
  ocpl::Handle CurrentHandle() {return *im;} //!< Iterator function
  bool exist(ocpl::Handle il) {
    for (First() ; !IsDone() ; Next() )
      if(il == CurrentHandle()) return true;
    return false;
  };
  void SetPrinting(bool set); //< Calls SetPrnting on all objects
  void Get(ocpl::command&);
  void Set(ocpl::command&);
protected:
  HandleVectList::iterator im;
  HandleVectList Value;
};

//! A HandleVect with a single entry
class HandleScalar : public HandleVectNoOwn {
public:
  HandleScalar() : HandleVectNoOwn() {};
  HandleScalar(ocpl::Handle hnd) : HandleVectNoOwn(hnd) {};
  ~HandleScalar() {Clear();};
  void Set(ocpl::command&);
  virtual void Add(const ocpl::Handle new_handle);
};




//! A HandleVect which owns it's handles (i.e. deletes them on destruction)
class HandleVect : public HandleVectNoOwn {
public:
  HandleVect() : HandleVectNoOwn() {};
  HandleVect(ocpl::Handle hnd) : HandleVectNoOwn(hnd) {};
  ~HandleVect() {_DEBUG_PRINT("In ~HV\n");Clear();};
  void Clear(); //!< Deletes all objects and clears the list
  void Delete(const ocpl::Handle handle);
};
  
#endif
