// Copyright (C) 2003 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

// parts of this module are based on
/***************************************************************************
                          Knewplot
                             -------------------
    begin                : Thu Mar 6 2003
    copyright            : (C) 2003 by Jos Koetsier & Donald MacDonald
    email                : Jos.Koetsier@paisley.ac.uk & Donald.MacDonald@paisley.ac.uk
 ***************************************************************************/

#include <FL/gl.h>
#include "line.h"
#include "axes.h"
#include "text.h"
#include "line_plotter.h"
#include "mathutils.h"

#define OBJ_NAME "line"

Line::Line(ocpl::Handle Parent, Matrix& XData, Matrix& YData) : Object(Parent)
{
  Properties["XData"]     = new Matrix(XData,1);
  Properties["YData"]     = new Matrix(YData,1);
  Properties["Label"]	 = new String("");
  
  _IsLegend = false;

  SET_TYPE;
  COPY_DEFAULT(Color,Color);
  COPY_DEFAULT(Marker,Radio);
  COPY_DEFAULT(MarkerFaceColor,ColorNone);
  COPY_DEFAULT(MarkerEdgeColor,ColorNone);
  COPY_DEFAULT(MarkerSize,Scalar);
  COPY_DEFAULT(LineWidth,Scalar);
  COPY_DEFAULT(Clipping,Radio);
  COPY_DEFAULT(LineStyle,Radio);
  COPY_DEFAULT(ArrowHead,Radio);
  COPY_DEFAULT(ArrowLength,Scalar);
  COPY_DEFAULT(ArrowWidth,Scalar);
  COPY_DEFAULT(ArrowRatio,Scalar);
 
  //! 2D for now
  min[2] = ocpl::nan;
  max[2] = ocpl::nan;
  lmin[2] = ocpl::nan;
  lmax[2] = ocpl::nan;

  FindMinMax(XData,min[0],max[0],lmin[0],lmax[0],YData.len());
  FindMinMax(YData,min[1],max[1],lmin[1],lmax[1]);
  
}

void Line::PostSet(ocpl::command& com)
{
  std::string prop(tolower(com.argin(1)->data));
  
  MAKE_REF(xdata,Matrix);
  MAKE_REF(ydata,Matrix);

  if(prop=="xdata")
    FindMinMax(xdata,min[0],max[0],lmin[0],lmax[0],xdata.len());
  if(prop=="ydata")
    FindMinMax(ydata,min[1],max[1],lmin[1],lmax[1]);
}


//! copies the line with all properies EXCEPT xdata & ydata (used by
// legend). Sets IsLegend to true
Line::Line(ocpl::Handle Parent, Line& ol) : Object(Parent)
{
  SET_TYPE;
  _IsLegend = true;

  double* xx= new double(0);
  double* yy= new double(0);

  // Insert a scalar into the x/y data
  Properties["XData"] = new Matrix(xx,1,1);
  Properties["YData"] = new Matrix(yy,1,1);

  // Copy all other properties
  COPY_PROPERTY(&ol,Label,String);
  COPY_PROPERTY(&ol,Color,Color);
  COPY_PROPERTY(&ol,Marker,Radio);
  COPY_PROPERTY(&ol,MarkerFaceColor,ColorNone);
  COPY_PROPERTY(&ol,MarkerEdgeColor,ColorNone);
  COPY_PROPERTY(&ol,MarkerSize,Scalar);
  COPY_PROPERTY(&ol,LineWidth,Scalar);
  COPY_PROPERTY(&ol,Clipping,Radio);
  COPY_PROPERTY(&ol,LineStyle,Radio);
  COPY_PROPERTY(&ol,Clipping,Radio);
  COPY_PROPERTY(&ol,ArrowHead,Radio);
  COPY_PROPERTY(&ol,ArrowLength,Scalar);
  COPY_PROPERTY(&ol,ArrowWidth,Scalar);
  COPY_PROPERTY(&ol,ArrowRatio,Scalar);
}

void Line::draw()
{
  IS_VISIBLE;

  MAKE_REF(xdata,Matrix);
  MAKE_REF(ydata,Matrix);
  MAKE_REF(clipping,Radio);
  MAKE_REF(linestyle,Radio);
  MAKE_REF(color,Color);
  MAKE_REF(linewidth,Scalar);
  MAKE_REF(markerfacecolor,ColorNone);
  MAKE_REF(markeredgecolor,ColorNone);
  MAKE_REF(marker,Radio);
  MAKE_REF(markersize,Scalar);
  MAKE_REF(arrowhead,Radio);
  MAKE_REF(arrowlength,Scalar);
  MAKE_REF(arrowwidth,Scalar);
  MAKE_REF(arrowratio,Scalar);
  
  Axes* axes = dynamic_cast<Axes*>(FindParentOfType("axes"));

  SET_CLIPPING;

  line_plotter::Instance().plot(xdata,
				ydata,
				linestyle,
				&color,
				linewidth(),
				markerfacecolor,
				markeredgecolor,
				marker,
				markersize(),
				axes,
				arrowhead,
				arrowlength(),
				arrowwidth(),
				arrowratio(),
				printing,
				false,
				IsLegend());
  UNSET_CLIPPING;
}

