'use strict'

const path    = require('path')
const resolve = require('rollup-plugin-node-resolve')
const common  = require('rollup-plugin-commonjs')
const buble   = require('rollup-plugin-buble')

const BUNDLE  = process.env.BUNDLE === 'true'

let fileDest  = 'mocha.js'
const plugins = [
  resolve({
    customResolveOptions: {
      moduleDirectory: ['/usr/lib/nodejs'],
      preferBuiltins: false
    }
  }),
  common(),
  buble()
]
module.exports = {
  input: 'browser-entry.js',
  output: {
    file: path.resolve(__dirname, `../${fileDest}`),
    format: 'umd',
    name: 'mocha'
  },
  plugins
}
