
#include "mysql_table_editor_fe.h"
#include "grtdb/db_object_helpers.h"

#include "mysql_table_editor_trigger_page.h"

//------------------------------------------------------------------------------
DbMySQLTableEditorTriggerPage::DbMySQLTableEditorTriggerPage(DbMySQLTableEditor *owner
                                                          ,MySQLTableEditorBE *be
                                                          ,Glib::RefPtr<Gtk::Builder>         xml)
                             : _owner(owner)
                             , _be(be)
                             , _xml(xml)
{
  _trigger_code.be(_be->get_sql_editor());
  
  Gtk::HBox* trigger_code_win;
  _xml->get_widget("trigger_code_holder", trigger_code_win);
  _trigger_code.widget().set_size_request(-1, 100);
  trigger_code_win->add(_trigger_code.container());
  _owner->add_sqleditor_text_change_timer(&_trigger_code, sigc::mem_fun(this, &DbMySQLTableEditorTriggerPage::parse_sql));
  trigger_code_win->resize_children();
  
  //Gtk::Paned *paned(0);
  //_xml->get("trigger_paned", &paned);

  _trigger_code.set_text(_be->get_all_triggers_sql());
}

//------------------------------------------------------------------------------
DbMySQLTableEditorTriggerPage::~DbMySQLTableEditorTriggerPage()
{
}

//------------------------------------------------------------------------------
void DbMySQLTableEditorTriggerPage::switch_be(MySQLTableEditorBE* be)
{
  _be = be;
  _trigger_code.be(_be->get_sql_editor());
  _trigger_code.set_text(_be->get_all_triggers_sql());
}

//------------------------------------------------------------------------------
void DbMySQLTableEditorTriggerPage::refresh()
{
  if (_be->get_sql_editor()->is_refresh_enabled())
  {
    _be->get_sql_editor()->is_refresh_enabled(false);
    _trigger_code.set_text(_be->get_all_triggers_sql());
  }
  _trigger_code.check_sql();
}

//------------------------------------------------------------------------------
void DbMySQLTableEditorTriggerPage::parse_sql(const std::string& sql)
{
  _trigger_code.reset_sql_check_state();
  _be->set_triggers_sql(_trigger_code.get_text(), false);
}

//------------------------------------------------------------------------------
void DbMySQLTableEditorTriggerPage::error_selected(const int lineno, const std::string& msg)
{
  _trigger_code.scroll_to(lineno, msg);
}
