
#ifndef _MODEL_PANEL_H_
#define _MODEL_PANEL_H_

#include <map>
#include <gtkmm/paned.h>
#include <gtkmm/notebook.h>
#include <gtkmm/box.h>
#include <gtkmm/builder.h>
#include "linux_utilities/form_view_base.h"

#include "workbench/wb_overview.h"
#include "workbench/wb_context_ui.h"

class OverviewPanel;
class HistoryTree;
class UserTypesBox;
class DocumentationBox;

class ModelPanel : public Gtk::HPaned, public FormViewBase
{
public:
  static ModelPanel *create(wb::WBContextUI *wb, wb::OverviewBE *overview);
  virtual ~ModelPanel();
  
  virtual bool on_close();
  virtual std::string get_title();
  virtual Gtk::Widget *get_panel() { return _top_box; }
  virtual bec::UIForm *get_form() const;
  virtual void toggle_sidebar();

  virtual void reset_layout() { _editor_paned->set_position(_editor_paned->get_height()-300); }
  OverviewPanel *get_overview() { return _overview; }

  void selection_changed();
  
  virtual void find_text(const std::string &text);
    
private:
  wb::WBContextUI *_wb;
  OverviewPanel *_overview;
  Gtk::VBox *_top_box;
  Gtk::Paned *_editor_paned;
  Gtk::Widget *_sidebar;
  bec::NodeId                  _last_found_node;

  HistoryTree                 *_history_tree;
  UserTypesBox                *_usertypes_box;
  DocumentationBox            *_documentation_box;

  friend class Gtk::Builder;
  ModelPanel(GtkHPaned *paned, Glib::RefPtr<Gtk::Builder> xml);
  void post_construct(wb::WBContextUI *wb, wb::OverviewBE *overview, Glib::RefPtr<Gtk::Builder> xml);
};


#endif /* _MODEL_PANEL_H_ */
