/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _DB_OBJECT_MATCH_H_
#define _DB_OBJECT_MATCH_H_

#include <boost/bind.hpp>

#include "grtpp_util.h"
#include "wbpublic_public_interface.h"

#include "base/string_utilities.h"
#include "grt/common.h"
#include "grtdb/charset_utils.h"
#include "grtsqlparser/sql_facade.h"
#include "db_object_helpers.h"

namespace grt
{

struct WBPUBLICBACKEND_PUBLIC_FUNC DbObjectMatchAlterOmf : public Omf
{
  virtual bool less(const ValueRef& , const ValueRef&) const;
  virtual bool equal(const ValueRef& , const ValueRef&) const;
};

typedef boost::function<bool (const ValueRef obj1, const ValueRef obj2, const std::string name, grt::GRT* grt)> comparison_rule;
class WBPUBLICBACKEND_PUBLIC_FUNC NormalizedComparer
{
protected:
    std::map<std::string,std::list<comparison_rule> > rules;
    grt::GRT* _grt;
    bool _case_sensitive;
public:
    void init_omf(Omf* omf);
    NormalizedComparer(grt::GRT* grt, bool case_sensitive = false);
    void add_comparison_rule(const std::string& name, comparison_rule rule){rules[name].push_back(rule);};
    bool normalizedComparison(const ValueRef obj1, const ValueRef obj2, const std::string name);
};
  
  
} // namespace grt

#endif // _DB_OBJECT_MATCH_H_
