/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

namespace mforms {
  class Box;
  class ToolBar;
  class HyperText;
  class ScrollPanel;
  class ToolBarItem;
}

#include "wb_sql_editor_form.h"

#include <mforms/tabview.h>

class SnippetList;

class MYSQLWBBACKEND_PUBLIC_FUNC QuerySidePalette : public mforms::TabView, public base::trackable
{
private:
  SqlEditorForm::Ptr _owner;

  mforms::Box* _help_box;
  mforms::ToolBar* _help_toolbar;
  mforms::HyperText* _help_text;
  
  mforms::ScrollPanel* _snippet_box;
  mforms::ToolBar* _snippet_toolbar;
  SnippetList* _snippet_list;
  
  void click_link(const std::string &link);
  mforms::ToolBar* prepare_toolbar();
  void toolbar_item_activated(mforms::ToolBarItem* item);
  
  void snippet_selection_changed();
public:
  QuerySidePalette(const SqlEditorForm::Ref &owner);
  ~QuerySidePalette();

  void close_popover();
};

