/* position.c -- position setting 
 *
 * Copyright(C) 2001-2002 Elisa Manara <e@entropika.net>
 * This code is released under the GPL License version 2 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "melon.h"

GtkWidget *hentry, *ventry;
static void update_position (GtkWidget *widget, gpointer user_data);
void set_melon_position (void);

gint set_position (GtkWidget *widget, gpointer data)
{
	GtkWidget *pos_window;
	GtkWidget *vbox, *hbox, *hbox1, *hbox2;
	GtkWidget *button, *label;
	char text[16];

	/* window */
	pos_window = gtk_window_new( GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW (pos_window), GTK_WIN_POS_MOUSE);
	gtk_widget_set_usize( GTK_WIDGET (pos_window), 200, 70);
	gtk_window_set_title(GTK_WINDOW (pos_window), "Set Icon Position");
	gtk_widget_show(pos_window);

	/* vbox */
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( pos_window ), vbox );
	gtk_widget_show( vbox );

	/* hbox1 */
	hbox1 = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox1);
	gtk_widget_show( hbox1 );

	/* label */
	label = gtk_label_new ("X: ");
	gtk_box_pack_start (GTK_BOX (hbox1), label, FALSE, FALSE, 5);
	gtk_widget_show(label);

	/* Hposition entry */
	hentry = gtk_entry_new();
	gtk_entry_set_max_length (GTK_ENTRY( hentry ), 16);

	snprintf(text, 16, "%s", cfg_data.xposition);
	gtk_entry_set_text (GTK_ENTRY( hentry ), text);
	gtk_box_pack_start (GTK_BOX (hbox1), hentry, FALSE, FALSE, 5);
	gtk_widget_show(hentry);

	/* hbox2 */
	hbox2 = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox2);
	gtk_widget_show( hbox2 );

	/* label */
	label = gtk_label_new ("Y: ");
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 5);
	gtk_widget_show(label);

	/* Vposition entry */
	ventry = gtk_entry_new();
	gtk_entry_set_max_length (GTK_ENTRY( ventry ), 16);

	snprintf(text, 16, "%s", cfg_data.yposition);
	gtk_entry_set_text (GTK_ENTRY( ventry ), text);
	gtk_box_pack_start (GTK_BOX (hbox2), ventry, FALSE, FALSE, 5);
	gtk_widget_show(ventry);

	/* hbox */
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( vbox ), hbox);
	gtk_widget_show( hbox );

	/* APPLY button */
	button = gtk_button_new_with_label ("Apply");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(update_position), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	/* CLOSE button */
	button = gtk_button_new_with_label ("Close");
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),
		GTK_OBJECT (pos_window));
	gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	return 1;

}

void update_position (GtkWidget *widget, gpointer user_data)
{
	char *text;

	text = gtk_editable_get_chars(GTK_EDITABLE( hentry ), 0, -1);
	if (text[0] != '\0')
		strncpy(cfg_data.xposition, text, 16);

	g_free(text);

	text = gtk_editable_get_chars(GTK_EDITABLE( ventry ), 0, -1);
	if (text[0] != '\0')
		strncpy(cfg_data.yposition, text, 16);

	g_free(text);

	set_melon_position();
	config_update();

	return;
}
	
