/*!******************************************************************************

  @file         hgg999.h

  ------------------------------------------------------------------------------

  @author       UweH

  @brief        KernelAdministration_Interface

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

\endif

********************************************************************************/

#ifndef HGG999_H
#define HGG999_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xb7\xa9\xef\x81\x15\x28\xb9\x84\x1e\x53\x81\x7a\x9e\x44\xe0\x5c'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "ggg00.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void gg999allocate ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999Activate (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999Restart (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Date            VAR_ARRAY_REF  untildate,
    tsp00_Time            VAR_ARRAY_REF  untiltime,
    tsp00_Uint4                          untilIOSequence);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999Shutdown (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999Offline (
    tgg00_BasisError                     error);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999BackupData (
    tgg00_MessBlock       VAR_VALUE_REF  mblock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999RestoreData (
    tgg00_MessBlock       VAR_VALUE_REF  mblock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999BackupLog (
    tgg00_MessBlock       VAR_VALUE_REF  mblock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999RestoreLog (
    tgg00_MessBlock       VAR_VALUE_REF  mblock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999BackupRestoreHandling (
    tgg00_MessBlock       VAR_VALUE_REF  mblock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999PermitBackupAndRestore ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_BasisError gg999DenyBackupAndRestore ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999ClearLog (
    tsp00_TaskId                         taskid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999RedoLogForRestore (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Date            VAR_ARRAY_REF  untildate,
    tsp00_Time            VAR_ARRAY_REF  untiltime,
    tsp00_Uint4                          untilIOSequence);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999AbortRedoLog (
    tgg00_BasisError                     abortReason);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999GetRedoLogProgressInfo (
    tsp00_Int4            VAR_VALUE_REF  transread,
    tsp00_Int4            VAR_VALUE_REF  transredone);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999InitConfig (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999AddDataVolume (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_VFilename       VAR_ARRAY_REF  volumeName,
    tsp00_Int4                           newVolumeSize,
    tsp00_Int2                           volumeId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999AddLogVolume (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_VFilename       VAR_ARRAY_REF  volumeName,
    tsp00_VFilename       VAR_ARRAY_REF  mirrorVolumeName,
    tsp00_Int4                           newVolumeSize,
    tsp00_Int2                           volumeId);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999GetRestartVersion (
    tgg00_MessBlock       VAR_VALUE_REF  mblock);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg999IsCheckBackupConfigured ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999GetNewCommandId (
    tsp00_TaskId                         taskid,
    tgg00_UtilCmdId       VAR_VALUE_REF  id);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999ReIntegrateBadLogVolume (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_VFilename       VAR_ARRAY_REF  devicename);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999GetBadLogVolume (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_VFilename       VAR_ARRAY_REF  devicename);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999SetLogAutoOverwrite (
    tsp00_TaskId                         taskid,
    pasbool                              on);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg999IsLogAutoOverwriteEnabled (
    tsp00_TaskId                         taskid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999SetLogWriting (
    tsp00_TaskId                         taskid,
    pasbool                              on);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg999IsLogWritingEnabled (
    tsp00_TaskId                         taskid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999SetKernelStateOnline ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg999KernelStateIsOnline ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg999KernelStateIsAdmin ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg999KernelStateIsRestart ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999GetBlockAddress (
    tsp00_TaskId                         taskId,
    tsp00_PageNo                         pageNo,
    tgg00_RecoveryMode_Param                 recMode,
    tsp00_Int4            VAR_VALUE_REF  deviceNo,
    tsp00_Int4            VAR_VALUE_REF  blockNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999SetNewBlockAddress (
    tsp00_TaskId                         taskId,
    tgg00_BasisError      VAR_VALUE_REF  error,
    tsp00_PageNo                         pageNo,
    tgg00_RecoveryMode_Param                 recMode,
    tsp00_Int4                           deviceNo,
    tsp00_Int4                           blockNo);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999DeleteBlockAddress (
    tsp00_TaskId                         taskId,
    tgg00_BasisError      VAR_VALUE_REF  error,
    tsp00_PageNo                         pageNo,
    tgg00_RecoveryMode_Param                 recMode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tgg00_BasisError gg999SuspendLogWriter (
    tsp00_TaskId                         taskid,
    Log_IOSequenceNo&                    lastWrittenIOsequence);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999ResumeLogWriter (
    tsp00_TaskId                         taskid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999NewDBIdentIfHistoryLost (
    tsp00_TaskId                         taskid);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool gg999IsStandby ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999InitStandby (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999InsertStandby (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_NodeId          VAR_ARRAY_REF  newNode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999RemoveStandby (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_NodeId          VAR_ARRAY_REF  oldNode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999RestartStandby (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999RestartStandbyServer (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999RegisterStandby (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_NodeId          VAR_ARRAY_REF  newStandbyNode,
    tsp00_Int4                           firstNeededOffset,
    tsp00_Int4            VAR_VALUE_REF  maxValidOffset);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999PrepareStandby (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_NodeId          VAR_ARRAY_REF  newStandbyNode);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999TakeOver (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 gg999Synchronize (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    tsp00_Int4                           newMaxOffset);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999TriggerSynchronize (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999SynchronizeServer (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999BroadcastBackupHistoryEntry (
    tsp00_TaskId                         taskid,
    char *                               backup_info,
    tsp00_Int4                           info_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999BroadcastBackupMediumDefEntry (
    tsp00_TaskId                         taskid,
    char *                               backup_info,
    tsp00_Int4                           info_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999CreateSnapShot (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999ActivateSnapShot (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void gg999DropSnapShot (
    tgg00_TransContext    VAR_VALUE_REF  trans);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool ggg999CheckDataCompatibility (
    tsp00_Version         VAR_ARRAY_REF  checkVersion);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool ggg999OmsContainerNeedMigration ();

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void ggg999WriteUserForcedDump (
    tsp00_TaskId                         TaskId,
    tsp00_VFilename       VAR_ARRAY_REF  FileName,
    tgg00_DumpStateSet    VAR_ARRAY_REF  DumpStateSet);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void ggg999CheckData (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    pasbool                              bWithExtendedCheck,
    pasbool                              bWithIndexes,
    tsp00_Int4            VAR_VALUE_REF  badIndexCount,
    tsp00_Int4            VAR_VALUE_REF  totalBadCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void ggg999CheckDataWithUpdate (
    tgg00_TransContext    VAR_VALUE_REF  trans,
    pasbool                              bWithExtendedCheck,
    tsp00_Int4            VAR_VALUE_REF  pagesUsed,
    tsp00_Int4            VAR_VALUE_REF  blocksReleased,
    tsp00_Int4            VAR_VALUE_REF  badIndexCount,
    tsp00_Int4            VAR_VALUE_REF  totalBadCount);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

