#ifndef WDVDelete_COMMONUTILS_H
#define WDVDelete_COMMONUTILS_H
/****************************************************************************

  module      : WDVDelete_CommonUtils.h

  -------------------------------------------------------------------------

  responsible : Daniel Kirmse

  special area: 
  description : 


  last changed: 2001-03-28  16:57
  see also    : 

  -------------------------------------------------------------------------


    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/

	#include "SAPDB/WebDAV/DeleteService/WDVDelete_CommonInclude.h"
	#include "SAPDB/WebDAV/DeleteService/WDVDelete_Connection.h"

	/****************************************************************************
	/
	/ Registry Sections
	/
	*****************************************************************************/

	#ifdef REG_WIN32

		#define WDVD_WEBDAV_REGISTRY			"SOFTWARE\\SAP\\SAP DBTech"

	#else

		#define WDVD_WEBDAV_REGISTRY			"/usr/spool/sql/ini/xie.ini"

	#endif

	/*------------------------------------------------------------------------
	Function	:	getFirstHeaderLine
	Description	:	gets the values of host, port and requestURI from the first
					line of the HTTP header
	Parameters	:	[in/out] host
					[in/out] port
					[in/out] uri
	Return		:	
	--------------------------------------------------------------------------*/
	void getFirstHeaderLine(sapdbwa_Handle		wa,
						    sapdbwa_HttpRequestP request,
		                    WDVD_PChar *host,
							WDVD_PChar *port, 
							WDVD_PChar uri);

	void getWebDAVPrefix(sapdbwa_Handle		wa,
						 WDVD_Char *prefix);

	/*------------------------------------------------------------------------
		Function:	getRequestUri
	--------------------------------------------------------------------------*/
	void getRequestUri(sapdbwa_Handle		wa,
					   sapdbwa_HttpRequestP request,
					   WDVD_PChar uri);
	void getRequestUriFromString(sapdbwa_Handle			wa,
								 sapdbwa_HttpRequestP	request,
								 WDVD_PChar				uri); 

	/*------------------------------------------------------------------------
	Function	:	buildServerString
	Description	:	returns the server as string (host + port)
	Parameters	:	[in/out] server
	Return		:	
	--------------------------------------------------------------------------*/
	void buildServerString(sapdbwa_HttpRequestP request,
		                   WDVD_PChar *server);

	/*------------------------------------------------------------------------
		Function:	buildServerStringLong
	--------------------------------------------------------------------------*/
	void buildServerStringLong(sapdbwa_Handle		wa,
							   sapdbwa_HttpRequestP request,
							   WDVD_PChar *server);
	
	/*------------------------------------------------------------------------
		Function:	getIfHeader
	--------------------------------------------------------------------------*/
	WDVD_Bool getIfHeader(sapdbwa_HttpRequestP request,
		                  WDVD_Char *sIf,
						  WDVD_Int4 len);

	/*------------------------------------------------------------------------
		Function:	getIfHeaderList
	--------------------------------------------------------------------------*/
	WDVD_Bool getIfHeaderList(sapdbwa_Handle		wa,
							  sapdbwa_HttpRequestP request,
							  WDVCAPI_WDV wdv,
							  WDVCAPI_LockIdList *lockTokenList);		/* http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1120166 */

	/* Begin Correction: http://pts:1080/webpts?wptsdetail=yes&ErrorType=1&ErrorID=1120395 */
	/*------------------------------------------------------------------------
		Function:	getContentRangeHeader
	--------------------------------------------------------------------------*/
	WDVD_Bool getContentRangeHeader(sapdbwa_HttpRequestP request,
									WDVD_Char **from, WDVD_Char **to);

	WDVD_Bool getUserAgentHeader(sapdbwa_HttpRequestP request,
		                  WDVD_Char *sUA,
						  WDVD_Int4 len);

	/*------------------------------------------------------------------------
	    Function: isNumber
	--------------------------------------------------------------------------*/
	WDVD_Bool isNumber(WDVD_Char *str);
	/* End Correction: http://pts:1080/webpts?wptsdetail=yes&ErrorType=1&ErrorID=1120395 */

	/*------------------------------------------------------------------------
		Function:	getLockTokenHeader
	--------------------------------------------------------------------------*/
	WDVD_Bool getLockTokenHeader(sapdbwa_HttpRequestP request,
								 WDVD_Char *sLockToken,
								 WDVD_Char *errormsg);			/* http://pts:1080/webpts?wptsdetail=yes&ErrorType=0&ErrorID=1124197 */

	/*------------------------------------------------------------------------
		Function:	getDcHeader
	--------------------------------------------------------------------------*/
	WDVD_Bool getDcHeader(sapdbwa_HttpRequestP request,
		                  WDVD_Char *sDc);

	/*------------------------------------------------------------------------
		Function:	getAsyncHeader
	--------------------------------------------------------------------------*/
	WDVD_Bool getAsyncHeader(sapdbwa_HttpRequestP request,
							 WDVD_Bool *async);

	/*------------------------------------------------------------------------
		Function:	getDeletedItemsHeader
	--------------------------------------------------------------------------*/
	WDVD_Bool getDeletedItemsHeader(sapdbwa_HttpRequestP request,
									WDVD_Bool *delitems);

	/*------------------------------------------------------------------------
		Function:	createErrorhHandle
	--------------------------------------------------------------------------*/
	WDVD_Bool createErrorHandle(WDVD_ErrorHandle *error);

	/*------------------------------------------------------------------------
		Function:	resetErrorHandle
	--------------------------------------------------------------------------*/
	WDVD_Bool resetErrorHandle(WDVD_ErrorHandle error);

	/*------------------------------------------------------------------------
		Function:	destroyErrorHandle
	--------------------------------------------------------------------------*/
	WDVD_Bool destroyErrorHandle(void *error);

	/*------------------------------------------------------------------------
		Function:	createConnUserData
	--------------------------------------------------------------------------*/
	WDVD_Bool createConnUserData(WDVD_ConnUserData *userdata);

	/*------------------------------------------------------------------------
		Function:	destroyConnUserData
	--------------------------------------------------------------------------*/
	WDVD_Bool destroyConnUserData(void *userdata);

	WDVD_Bool getParameterValue(const WDVD_Char *pParamName,
				 	 		    sapdbwa_HttpRequestP req,
				 	 		    WDVD_Char *sValue);
	const WDVD_Char* getParameterValueWithoutCopy(const WDVD_Char *pParamName,
				 	 					sapdbwa_HttpRequestP req);

	WDVD_Bool checkAuthentication(sapdbwa_Handle		wa,
								  sapdbwa_HttpRequestP	req,
								  sapdbwa_HttpReplyP	rep,
								  SAPDB_Char			*isRequired,
								  SAPDB_Char			*user,
								  SAPDB_Char			*password);


#endif
