/*!***************************************************************************

  module      : RTE_Test
  responsible : JoergM
  special area: RunTime
  created     : 2000-11-22
  last changed: 2000-11-22 12:00
  description : entrypoint for component tests



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "RunTime/RTE_Test.hpp"
#include "RunTime/RTE_Message.hpp"
#include "SAPDBCommon/SAPDB_ToString.hpp"
#if !defined(_WIN32)
#include <unistd.h>
#endif

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/
/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/
/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/
/*===========================================================================*
 *  LOCAL FUNCTIONS                                                          *
 *===========================================================================*/
/*===========================================================================*
 *  EXTERNAL FUNCTIONS                                                       *
 *===========================================================================*/

extern "C" void vgetpid(RTE_TaskId & tid);
extern "C" void vsleep(RTE_TaskId  tid,
					   SAPDB_Int2 limitInSeconds );

externCpp void RTE_Test (tgg00_TransContext& Trans)
{
    ROUTINE_DBG_MSP00 ("RTE_Test");
	RTE_TaskId tid;
    SAPDB_Int4 countDown = 10;

	vgetpid(tid);

	while ( !Trans.trRteCommPtr_gg00->to_cancel && --countDown > 0 )
	{
//		vsleep(tid, 1);
//		RTE_Message( SAPDBErr_MessageList("RTETEST",__CONTEXT__,
//			SAPDBErr_MessageList::Info,19823,"RTE_Test function called from running Task T%s", 1, ToStr(tid) ));
#if defined(_WIN32)
    	Sleep(1000);
#else
	    sleep(1);
#endif
	}

#if defined(_WIN32)
	Sleep(3000);
#else
	sleep(3);
#endif
	RTE_Message( SAPDBErr_MessageList("RTETEST",__CONTEXT__,
		SAPDBErr_MessageList::Info,19823,"RTE_Test function called from cancelled Task T%s", 1, ToStr(tid) ));
}
