/*
        ========== licence begin  GPL
        Copyright (C) 2005 SAP AG

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
        ========== licence end
 */
#ifndef RTE_CONSOLE_THREAD_MESSAGES_HPP
#define RTE_CONSOLE_THREAD_MESSAGES_HPP

// Generated Header file RTE_Console_Thread_Messages.hpp.
// Generated by genmsg V2.2 DO NOT EDIT

#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"

#define RTEERR_THREAD_CONS_CREATE_REQ_COMM             SAPDBErr_MessageList::Error,13102,"Console Thread: Creation of request communication failed",0
#define RTEERR_THREAD_CONS_CREATE_REQ_COMM_ID 13102
#define RTEERR_THREAD_CONS_WORKER_THRD_START           SAPDBErr_MessageList::Error,13103,"Console Thread: Starting worker thread %s failed with %s: %s",3
#define RTEERR_THREAD_CONS_WORKER_THRD_START_ID 13103
#define RTEERR_THREAD_CONS_WORKER_THRD_RES             SAPDBErr_MessageList::Error,13104,"Console Thread: Resuming worker thread %s failed with %s: %s",3
#define RTEERR_THREAD_CONS_WORKER_THRD_RES_ID 13104
#define RTEERR_THREAD_CONS_WORKER_THRD_SUSP            SAPDBErr_MessageList::Error,13105,"Console Thread: Suspending worker thread %s failed with %s: %s",3
#define RTEERR_THREAD_CONS_WORKER_THRD_SUSP_ID 13105
#define RTEERR_THREAD_CONS_NO_FREE_CONNECTION          SAPDBErr_MessageList::Error,13106,"Console Thread: No free connection available for client PID %s, Ref. %s",2
#define RTEERR_THREAD_CONS_NO_FREE_CONNECTION_ID 13106
#define RTEERR_THREAD_CONS_FREELIST_INCONS             SAPDBErr_MessageList::Error,13107,"Console Thread: Connection free list is inconsitent",0
#define RTEERR_THREAD_CONS_FREELIST_INCONS_ID 13107
#define RTEERR_THREAD_CONS_CONNECTION_IN_USE           SAPDBErr_MessageList::Error,13108,"Console Thread: Connection list item is in use by connection ID %s",1
#define RTEERR_THREAD_CONS_CONNECTION_IN_USE_ID 13108
#define RTEERR_THREAD_CONS_INIT_WORKER                 SAPDBErr_MessageList::Error,13110,"Console Thread: Initialization of  reply worker failed",0
#define RTEERR_THREAD_CONS_INIT_WORKER_ID 13110
#define RTEERR_THREAD_CONS_CONNECT_FAILED              SAPDBErr_MessageList::Error,13111,"Console Thread: Connection failed",0
#define RTEERR_THREAD_CONS_CONNECT_FAILED_ID 13111
#define RTEERR_THREAD_CONS_DISCONNECT_FAILED           SAPDBErr_MessageList::Error,13112,"Console Thread: Disconnect failed",0
#define RTEERR_THREAD_CONS_DISCONNECT_FAILED_ID 13112
#define RTEERR_THREAD_CONS_DELETE_CONNECTION           SAPDBErr_MessageList::Error,13113,"Console Thread: Removing connection failed: wanted ID = %s, actual ID = %s",2
#define RTEERR_THREAD_CONS_DELETE_CONNECTION_ID 13113
#define RTEERR_THREAD_CONS_CONNECT                     SAPDBErr_MessageList::Error,13114,"Console Thread: Connect request failed",0
#define RTEERR_THREAD_CONS_CONNECT_ID 13114
#define RTEERR_THREAD_CONS_REQUEST                     SAPDBErr_MessageList::Error,13115,"Console Thread: Data request failed",0
#define RTEERR_THREAD_CONS_REQUEST_ID 13115
#define RTEERR_THREAD_CONS_RELEASE                     SAPDBErr_MessageList::Error,13116,"Console Thread: Release request failed",0
#define RTEERR_THREAD_CONS_RELEASE_ID 13116
#define RTEERR_THREAD_CONS_WORKER_THREADS              SAPDBErr_MessageList::Error,13117,"Console Thread: No worker threads could be created",0
#define RTEERR_THREAD_CONS_WORKER_THREADS_ID 13117
#define RTEERR_THREAD_CONS_INIT_REQUESTOR              SAPDBErr_MessageList::Error,13118,"Console Thread: Initialization of requestor failed",0
#define RTEERR_THREAD_CONS_INIT_REQUESTOR_ID 13118
#define RTEERR_THREAD_CONS_COMMUNICATION_TYPE          SAPDBErr_MessageList::Error,13122,"Console Thread: Wrong communication type: %s",1
#define RTEERR_THREAD_CONS_COMMUNICATION_TYPE_ID 13122
#define RTEERR_THREAD_CONS_SEND_REPLY                  SAPDBErr_MessageList::Error,13123,"Console Thread: Sending reply data for connection ID %s failed",1
#define RTEERR_THREAD_CONS_SEND_REPLY_ID 13123
#define RTEERR_THREAD_CONS_INIT_CONNECT_LIST           SAPDBErr_MessageList::Error,13124,"Console Thread: Initialization of connection list failed",0
#define RTEERR_THREAD_CONS_INIT_CONNECT_LIST_ID 13124
#define RTEERR_THREAD_CONS_INIT_CONNECT_SLOT           SAPDBErr_MessageList::Error,13125,"Console Thread: Initialization of connection slot %s failed",1
#define RTEERR_THREAD_CONS_INIT_CONNECT_SLOT_ID 13125
#define RTEERR_THREAD_CONS_REQ_TYPE                    SAPDBErr_MessageList::Error,13128,"Console Thread: Wrong request type: expected = %s, actual = %s",2
#define RTEERR_THREAD_CONS_REQ_TYPE_ID 13128
#define RTEERR_THREAD_CONS_REQ_TYPE_UNKNOWN            SAPDBErr_MessageList::Error,13129,"Console Thread: Request type is unknown: %s",1
#define RTEERR_THREAD_CONS_REQ_TYPE_UNKNOWN_ID 13129
#define RTEERR_THREAD_CONS_INIT_REQ_COMM               SAPDBErr_MessageList::Error,13130,"Console Thread: Initialization of request communication failed",0
#define RTEERR_THREAD_CONS_INIT_REQ_COMM_ID 13130
#define RTEERR_THREAD_CONS_SET_FREE_CONNECTION         SAPDBErr_MessageList::Error,13131,"Console Thread: Freeing connection slot %s failed",1
#define RTEERR_THREAD_CONS_SET_FREE_CONNECTION_ID 13131
#define RTEERR_THREAD_CONS_STORE_EVENT                 SAPDBErr_MessageList::Error,13136,"Console Thread: Storing event list failed",0
#define RTEERR_THREAD_CONS_STORE_EVENT_ID 13136
#define RTEERR_THREAD_CONS_SEND_ERR                    SAPDBErr_MessageList::Error,13138,"Console Thread: Send error reply failed",0
#define RTEERR_THREAD_CONS_SEND_ERR_ID 13138
#define RTEERR_THREAD_CONS_FIFO_PROT_VERSION           SAPDBErr_MessageList::Error,13139,"Console Thread: Wrong FIFO protocol version: expected = %s, actual = %s",2
#define RTEERR_THREAD_CONS_FIFO_PROT_VERSION_ID 13139
#define RTEERR_THREAD_CONS_FIFO_PROT_ID                SAPDBErr_MessageList::Error,13140,"Console Thread: Wrong FIFO protocol ID: expected = %s, actual = %s",2
#define RTEERR_THREAD_CONS_FIFO_PROT_ID_ID 13140
#define RTEERR_THREAD_CONS_FIFO_DATA_LEN               SAPDBErr_MessageList::Error,13141,"Console Thread: Wrong data length: expected = %s, packet length = %s, total length = %s",3
#define RTEERR_THREAD_CONS_FIFO_DATA_LEN_ID 13141
#define RTEERR_THREAD_CONS_FIFO_PACKET_HEADER          SAPDBErr_MessageList::Error,13142,"Console Thread: Get current packet header information from request communication failed",0
#define RTEERR_THREAD_CONS_FIFO_PACKET_HEADER_ID 13142
#define RTEERR_THREAD_CONS_PROTOCOL_ERROR              SAPDBErr_MessageList::Error,13143,"Console Thread: Protocol error",0
#define RTEERR_THREAD_CONS_PROTOCOL_ERROR_ID 13143
#define RTEERR_THREAD_CONS_GET_DATA                    SAPDBErr_MessageList::Error,13144,"Console Thread: Getting request data failed",0
#define RTEERR_THREAD_CONS_GET_DATA_ID 13144
#define RTEERR_THREAD_CONS_SEND_DATA                   SAPDBErr_MessageList::Error,13145,"Console Thread: Sending reply data failed",0
#define RTEERR_THREAD_CONS_SEND_DATA_ID 13145
#define RTEERR_THREAD_CONS_FREE_LIST_INCONSIST         SAPDBErr_MessageList::Error,13147,"Console Thread: Free list is inconsistent",0
#define RTEERR_THREAD_CONS_FREE_LIST_INCONSIST_ID 13147
#define RTEERR_THREAD_CONS_ALLOC_EVENT                 SAPDBErr_MessageList::Error,13148,"Console Thread: Allocation of %s bytes for event data failed",1
#define RTEERR_THREAD_CONS_ALLOC_EVENT_ID 13148
#define RTEERR_THREAD_CONS_REQ_PROCESSING              SAPDBErr_MessageList::Error,13149,"Console Thread: Error while processing request command %s",1
#define RTEERR_THREAD_CONS_REQ_PROCESSING_ID 13149
#define RTEERR_THREAD_CONS_ALLOC_DATA                  SAPDBErr_MessageList::Error,13150,"Console Thread: Allocation of %s bytes for reply data for command %s failed",2
#define RTEERR_THREAD_CONS_ALLOC_DATA_ID 13150
#define RTEERR_THREAD_CONS_TRACE_FLUSH                 SAPDBErr_MessageList::Error,13151,"Console Thread: Trace writer s not initialized",0
#define RTEERR_THREAD_CONS_TRACE_FLUSH_ID 13151
#define RTEERR_THREAD_CONS_TIMEOUT_THRD_START          SAPDBErr_MessageList::Error,13152,"Console Thread: Starting semaphore timeout thread failed with %s: %s",2
#define RTEERR_THREAD_CONS_TIMEOUT_THRD_START_ID 13152
#define RTEERR_THREAD_CONS_WAIT_CONFIRMATION           SAPDBErr_MessageList::Error,13153,"Console Thread: Wait for confirmation failed",0
#define RTEERR_THREAD_CONS_WAIT_CONFIRMATION_ID 13153
#define RTEWARN_THREAD_CONS_CONNECT_EXISTING           SAPDBErr_MessageList::Warning,13300,"Console Thread: Connection does not exist anymore; Wanted ID: %s, is ID: %s",2
#define RTEWARN_THREAD_CONS_CONNECT_EXISTING_ID 13300
#define RTEWARN_THREAD_CONS_FREE                       SAPDBErr_MessageList::Warning,13301,"Console Thread: Connection slot is free",0
#define RTEWARN_THREAD_CONS_FREE_ID 13301
#define RTEWARN_THREAD_CONS_CRASH_THREAD               SAPDBErr_MessageList::Warning,13302,"Console Thread: Creating crash dump thread failed",0
#define RTEWARN_THREAD_CONS_CRASH_THREAD_ID 13302
#define RTEINFO_THREAD_CONS_WORKER_THRD_STOP           SAPDBErr_MessageList::Info,13350,"Console Thread: Stopping worker thread %s",1
#define RTEINFO_THREAD_CONS_WORKER_THRD_STOP_ID 13350
#define RTEINFO_THREAD_CONS_TIMEOUT                    SAPDBErr_MessageList::Info,13351,"Console Thread: Timeout occurred: Deleting client connection %s (PID %s, Ref. %s) at connection slot %s",4
#define RTEINFO_THREAD_CONS_TIMEOUT_ID 13351
#define RTEINFO_THREAD_CONS_CLIENT_DIED                SAPDBErr_MessageList::Info,13352,"Console Thread: Client died: Deleting client connection %s (PID %s, Ref. %s) at connection slot %s",4
#define RTEINFO_THREAD_CONS_CLIENT_DIED_ID 13352
#define RTEINFO_THREAD_CONS_CREATE_CONNECTION          SAPDBErr_MessageList::Info,13354,"Console Thread: Create connection %s (PID %s, Ref. %s) at connection slot %s",4
#define RTEINFO_THREAD_CONS_CREATE_CONNECTION_ID 13354
#define RTEINFO_THREAD_CONS_OPEN_CONNECTION            SAPDBErr_MessageList::Info,13355,"Console Thread: Open connection %s (PID %s, Ref. %s) at connection slot %s",4
#define RTEINFO_THREAD_CONS_OPEN_CONNECTION_ID 13355
#define RTEINFO_THREAD_CONS_RELEASE_CONNECTION         SAPDBErr_MessageList::Info,13356,"Console Thread: Close connection %s (PID %s, Ref. %s) at connection slot %s",4
#define RTEINFO_THREAD_CONS_RELEASE_CONNECTION_ID 13356
#define RTEINFO_THREAD_CONS_WORKER_THRD_BUSY           SAPDBErr_MessageList::Info,13357,"Console Thread: All worker threads are currently busy",0
#define RTEINFO_THREAD_CONS_WORKER_THRD_BUSY_ID 13357
#define RTEINFO_THREAD_CONS_CRASH_DUMP                 SAPDBErr_MessageList::Info,13358,"Console Thread: Creating crash dump",0
#define RTEINFO_THREAD_CONS_CRASH_DUMP_ID 13358

#endif /* RTE_CONSOLE_THREAD_MESSAGES_HPP */
