/*!**************************************************************************

  module      : Log_Types.cpp
  special area: Logging
  responsible : UweH
  created     : 2000-09-25  12:00
  last changed: 2000-10-27  12:00
  copyright:    (c) 2000-2004 SAP AG
  description : output functions for types defined here.



    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*****************************************************************************/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "Logging/Log_Types.hpp"
#ifndef INSLOWCI
#include "KernelCommon/Kernel_VTrace.hpp"
#include "RunTime/RTE_Message.hpp"
#include "Logging/Log_Exceptions.hpp"
#endif

/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/

static const char* ActionTypeStrings [] = // PTS 1134693 UH 2005-04-06 changed to static(local)
{
    "NoOp",
    "Commit",
    "Rollback",
    "PartialRollback",
    "NewObject",
    "InsertObject",
    "UpdateObject",
    "DeleteObject",
    "LockObject",
    "CreateObjectFile",
    "DropObjectFile",
    "InsertRecord",
    "DeleteRecord",
    "UpdateRecord",
    "ModifyTable",
    "ChangeFileType",
    "CreateFile",
    "CreateIndex",
    "CreateTable",
    "RenameFile",
    "SuccFileVersion",
    "UpdFileStatistic",
    "CopyBlob",
    "CopySameBlob",
    "ExpandBlob",
    "TruncateBlob",
    "UpdateBlob",
    "RefreshSequence",
    "RefreshSurrogate",
    "FinishOpenTrans",
    "SavepointEntry",
    "DeleteAllObjects",
    "ReorganizeFile",
    "ReloadFile",
    "UnloadFile",
    "SetFileState",
    "MultipleActions",
    "+++IllegalType+++" // PTS 1134693 UH 2005-04-06
};

/*---------------------------------------------------------------------------*/

const char* Log_GetActionTypeString(const Log_ActionType type)
{
    // PTS 1134693 UH 2005-04-06 new
    if ( type > Log_IllegalType )
        return ActionTypeStrings[Log_IllegalType];
	else
        return ActionTypeStrings[type];
}

/*---------------------------------------------------------------------------*/
const char * Log_ErrorStateStrings [] =
{
    "Ok",
    "LogAndDataIncompatible",
    "RawAllocationFailed",
    "PageAllocationFailed",
    "LogDeviceTooSmall",
    "InconsistentLogDeviceIOSequence",
    "LogSaveDistanceTooLarge",
    "LogSizeHasDecreased",
    "InconsistentLogInfoPage",
    "SavepointPositionNotFound",
    "Log_SaveForAbortedClearLog",
    "LogAndSoftwareIncompatible",
    "LogAreaOpenError"
};

/*---------------------------------------------------------------------------*/
const char * Log_DeviceStateStrings [] =
{
    "Okay",
    "HistoryLost",
    "Cleared",
    "Clearing",
    "PartiallyCleared",
    "PatiallyClearing"
};

/*---------------------------------------------------------------------------*/
const char * Log_FlushModeStrings [] =
{
    "MinimizeSpace",
    "MaximizeSafety"
};

/*---------------------------------------------------------------------------*/
const char * Log_DeviceCheckModeStrings [] =
{
    "QueueSequences",
    "IOSequences",
    "CheckAscendingSequences"
};

/*---------------------------------------------------------------------------*/
const char * Log_SavepointReasonStrings [] =
{
    "Unknown",
    "SaveData",
    "SavePages",
    "Restart",
    "Shutdown",
    "Distance",
    "Time",
    "UserRequested",
    "TransRequested", // not used
    "FreeBlockManagement",
    "DataWriter",
    "BDLockList", // not used
    "EndReadOnly",
    "DataCache", // not used
    "Log_Writer",
    "Converter",
    "EndLoad",
    "CreateIndex",
    "CheckTable",
    "CatalogMigration",
    "SplitMirror"
};

/*---------------------------------------------------------------------------*/
SAPDB_OStream & operator << (SAPDB_OStream &ostream, Log_IOSequenceNo ioSeq)
{
    if (ioSeq.IsInvalid())
    {
        return ostream << "NIL";
    }
    else
    {
        return ostream << ioSeq();
    }
}

/*---------------------------------------------------------------------------*/
void Log_EntryInfo::WriteToTrace(const char *title)
{
    #ifndef INSLOWCI
    Kernel_VTrace trace;
    if ( title != NULL )
        trace << title << ": ";
    trace << pageoffset << "." << entryoffset
          << " [" << iosequence << "] '"
          << Log_GetActionTypeString(entrytype)
          << "' " << entrydate << "-" << entrytime;
    #endif
}

/*---------------------------------------------------------------------------*/
void Log_EntryInfo::Message (const char *title,
              SAPDB_UInt  msgcount,
              SAPDB_UInt  transno,
              SAPDB_UInt  entrysequence)
{
    #ifndef INSLOWCI
    RTE_Message ( Log_Exception ( __CONTEXT__, LOG_ENTRY_INFO,
                  title,
                  SAPDB_ToString(msgcount,_T_d),
                  SAPDB_ToString(transno,_T_d),
                  SAPDB_ToString(entrysequence,_T_d),
                  SAPDB_ToString(iosequence,_T_d),
                  SAPDB_ToString(pageoffset,_T_d),
                  SAPDB_ToString(entryoffset,_T_d),
                  Log_GetActionTypeString(entrytype),
                  SAPDB_ToString(entrydate,_T_d),
                  SAPDB_ToString(entrytime,_T_d) ) );
    #endif
}
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
