# ------------------------------------------------------------------------------
#
# Restart Descriptions
#
# ------------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

regex(.*\.cpp$)    -except

# -------------------------------------------------------------------------------------
# basic types
# -------------------------------------------------------------------------------------

Rst_Types.hpp           inc=SAPDB_Types.hpp,Container_Vector.hpp

# ------------------------------------------------------------------------------
# Exceptions and Messages
# ------------------------------------------------------------------------------

Rst_Messages.genmsg    ascii

Restart_Messages.hpp   inc=SAPDBErr_MessageList.hpp

Rst_Exceptions.hpp     inc=SAPDBErr_MessageList.hpp \
                       dep=Restart_Messages.hpp


# -------------------------------------------------------------------------------------
# Redo Manager
# -------------------------------------------------------------------------------------

Rst_RedoManager.hpp         inc=ggg00,\
                                Kernel_DateTime.hpp,\
                                Rst_LogEntryIterator.hpp,\
                                Rst_Types.hpp

Rst_RedoManager.cpp         inc=RTE_Message.hpp,\
                                Rst_Exceptions.hpp,\
                                Rst_RedoManager.hpp,\
                                Rst_RedoTaskLifeCycle.hpp,\
                                Rst_RedoTrafficControl.hpp,\
                                Rst_RedoReadTask.hpp,\
                                Log_Volume.hpp,\
                                Log_Savepoint.hpp,\
                                Kernel_Trace.hpp,\
                                ggg00

Rst_IRedoReadTask.hpp       inc=

Rst_RedoFile.hpp            inc=SAPDB_Types.hpp,\
                                Data_ChainSplitSpaceForwardRead.hpp,\
                                Data_BaseFile.hpp,\
                                Log_AfterImageSpace.hpp,\
                                Log_Types.hpp

Rst_RedoFile.cpp            inc=SAPDBErr_Assertions.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_VTrace.hpp,\
                                Data_PageAccessManager.hpp,\
                                Data_Types.hpp,\
                                Rst_Exceptions.hpp,\
                                Rst_RedoFile.hpp

Rst_RedoReadTask.hpp        inc=ggg00,gsp00,\
                                Kernel_DateTime.hpp,\
                                SAPDB_Types.hpp,\
                                Rst_Types.hpp,\
                                Rst_IRedoReadTask.hpp,\
                                Rst_IRedoTrafficControl.hpp,\
                                Log_Transaction.hpp,\
                                Log_Types.hpp

Rst_RedoReadTask.cpp        inc=ggg92.h,hgg01.h,\
                                heo52.h,\
                                hkb50.h,hkb51.h,hkb57.h,hkb57_1.h,\
                                RTESync_Spinlock.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                SAPDBMem_NewDestroy.hpp,\
                                Kernel_IAdminRestartShutdown.hpp,\
                                Kernel_IAdminConfig.hpp,\
                                Kernel_Migration.hpp,\
                                Kernel_Version.hpp,\
                                Kernel_OpMsg.hpp,\
                                Rst_RedoReadTask.hpp,\
                                Rst_Exceptions.hpp,\
                                Rst_LogEntryIterator.hpp,\
                                Rst_IRedoTrafficControl.hpp,\
                                Log_VolumeIterator.hpp,\
                                Log_Volume.hpp,\
                                Log_Savepoint.hpp,\
                                Log_AfterImage.hpp,\
                                Log_ActionPartialRollback.hpp,\
                                Log_ActionObject.hpp,\
                                Log_ActionSavepoint.hpp,\
                                Log_OpenTransFile.hpp,\
                                Log_SeqTapeReader.hpp


Rst_RedoTaskLifeCycle.hpp   inc=SAPDB_Types.hpp,\
							    ggg00

Rst_RedoTaskLifeCycle.cpp   inc=Rst_RedoTaskLifeCycle.hpp,\
                                Kernel_Trace.hpp,\
                                Log_Types.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                ggg00,\
                                hgg01.h,hkb53.h,hkb90.h

Rst_IRedoTrafficControl.hpp inc=SAPDB_Types.hpp,\
                                Log_Types.hpp,\
                                Log_Transaction.hpp,\
                                Rst_Types.hpp,\
				gsp00,ggg00

Rst_RedoTrafficControl.hpp  inc=SAPDBMem_IRawAllocator.hpp

Rst_RedoTrafficControl.cpp  inc=Rst_IRedoTrafficControl.hpp,\
                                Rst_RedoTrafficControl.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                SAPDBMem_NewDestroy.hpp,\
                                Kernel_TaskWaitList.hpp,\
                                Kernel_VTrace.hpp,\
                                Kernel_IAdminBackupRecovery.hpp,\
                                Log_Types.hpp,\
                                Rst_Exceptions.hpp,\
                                Log_Transaction.hpp,\
                                gsp00,ggg00,ggg92.h,\
                                heo55k.h,heo56.h,hgg08.h,\
                                hkb50.h,hkb51.h,hkb53.h

Rst_LogEntryIterator.hpp    inc=Log_Types.hpp,\
                                Log_Page.hpp,\
                                Log_VolumeIterator.hpp,\
                                Rst_Types.hpp,\
                                Rst_Exceptions.hpp,\
                                Rst_StandbySynchronizer.hpp


Rst_LogEntryIterator.cpp    inc=Rst_LogEntryIterator.hpp,\
                                Log_Volume.hpp,\
                                hkb57_1.h


Rst_StandbySynchronizer.hpp inc=ggg00,\
                                gsp00,\
                                heo56.h,\
                                Log_Types.hpp,\
                                RTE_Crash.hpp,\
                                RTESync_NamedSpinlock.hpp,\
                                Kernel_IAdminHotStandby.hpp



&if $OSSPEC = LINUX #PTS 1110637
nodebug
&endif


# ------------------------------------------------------------------------------

