.TH "ZIP_FILE_EXTRA_FIELD_GET" "3" "February 20, 2013" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_extra_field_get\fR,
\fBzip_file_extra_field_get_by_id\fR
\- get extra field for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIconst\ zip_uint8_t\ *\fR
.br
\fBzip_file_extra_field_get\fR(\fIstruct zip *archive\fR,\ \fIzip_uint64_t index\fR,\ \fIzip_uint16_t extra_field_index\fR,\ \fIzip_uint16_t *idp\fR,\ \fIzip_uint16_t *lenp\fR,\ \fIzip_flags_t flags\fR);
.sp
\fIconst\ zip_uint8_t\ *\fR
.br
\fBzip_file_extra_field_get_by_id\fR(\fIstruct zip *archive\fR,\ \fIzip_uint64_t index\fR,\ \fIzip_uint16_t extra_field_id\fR,\ \fIzip_uint16_t extra_field_index\fR,\ \fIzip_uint16_t *lenp\fR,\ \fIzip_flags_t flags\fR);
.SH "DESCRIPTION"
The
\fBzip_file_extra_field_get\fR()
function returns the extra field with index
\fIextra_field_index\fR
for the file at position
\fIindex\fR
in the zip archive.
This pointer should not be modified or
free(3)'d,
and becomes invalid when
\fIarchive\fR
is closed.
If
\fIidp\fR
is not
\fRNULL\fR,
the integer to which it points will be set to the ID (two-byte
signature) of the selected extra field.
If
\fIlenp\fR
is not
\fRNULL\fR,
the integer to which it points will be set to the length of the
extra field.
Generally speaking,
\fIlenp\fR
and
\fIidp\fR
should be passed since only the extra field data is returned (i.e.,
neither the ID nor the length, if the
\fIidp\fR
and
\fIlenp\fR
arguments are not provided).
.PP
The following
\fIflags\fR
are supported:
.RS 6n
.TP 20n
\fRZIP_FL_CENTRAL\fR
Return extra fields from the archive's central directory.
.TP 20n
\fRZIP_FL_LOCAL\fR
Return extra fields from the local file headers.
.TP 20n
\fRZIP_FL_UNCHANGED\fR
Return the original unchanged extra fields, ignoring any changes made.
.RE
.PP
The
\fBzip_file_extra_field_get_by_id\fR()
function returns the extra field with ID (two-byte signature)
\fIextra_field_id\fR
and index
\fIextra_field_index\fR
(in other words, the
\fIextra_field_index\fR'th
extra field with ID
\fIextra_field_id\fR)
The other arguments are the same as for
\fBzip_file_extra_field_get\fR().
.SH "RETURN VALUES"
Upon successful completion, a pointer to an extra field is returned,
or
\fRNULL\fR
if there is no extra field with that
\fIextra_field_index\fR
for the file with index
\fIindex\fR.
In case of an error,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_file_extra_field_get\fR()
and
\fBzip_file_extra_field_get_by_id\fR()
fail if:
.TP 19n
[\fRZIP_ER_NOENT\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR,
or
\fIextra_field_index\fR
is not a valid extra file index (for ID
\fIextra_field_id\fR).
.SH "SEE ALSO"
libzip(3),
zip_file_extra_field_delete(3),
zip_file_extra_field_set(3),
zip_file_extra_fields_count(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
