 
#include "TePDIFusionFactory.hpp"
#include "TePDIFusion.hpp"
#include <TeAgnostic.h>


TePDIFusionFactory::TePDIFusionFactory()
: TePDIAlgorithmFactory( std::string( "TePDIFusion" ) )
{
};      


TePDIFusionFactory::~TePDIFusionFactory()
{
};


TePDIAlgorithm* TePDIFusionFactory::build ( const TePDIParameters& arg )
{
  TePDIAlgorithm* instance_ptr = new TePDIFusion();
  
  TEAGN_TRUE_OR_THROW( instance_ptr->Reset( arg ),
    "Invalid parameters" );
  
  return instance_ptr;
}
