#include "TeBayesFunctions.h"
#include "TeStatDataStructures.h"
#include "TeProxMatrixConstructionStrategy.h"
#include "TeGeneralizedProxMatrix.h"
#include "TeSTElementSet.h"

// TeGlobalEmpiricalBayes				// Function declaration
bool TeGlobalEmpiricalBayes(TeSTStatInstanceSet *rs, double rate)
{
	TeSTStatInstanceSet::iterator it = rs->begin();
	
	long int Narea=0;	// number of areas
	long int count;		// Counter
	double m_hat;		// the global rate
	double n_;			// the mean population in risk
	double s2=0;		// s2 = sum(n(i)(r(i) - m_hat)^2)/n
	double sum_n=0;		//
	double sum_y=0;		//
	vector<double> r;	// the rate for each area
	vector<double> n;	// the population in each area
	vector<double> y;	// the cases in each area
	double aux;			// auxiliary variable

	try{

		while(it != rs->end())
		{
			(*it).getDoubleProperty(0,aux);
			n.push_back(aux);
			(*it).getDoubleProperty(1,aux);
			y.push_back(aux);
			++Narea;
			r.push_back(y[Narea-1]/n[Narea-1]);
			sum_n+=n[Narea-1];
			sum_y+=y[Narea-1];
			++it;
		
			// Check if the population is smaller than the 
			// number of cases
			//if(n[Narea-1]<=y[Narea-1])
			//	throw TeGlobalBayesException(BAYES_GREATER_CASES);
			if(n[Narea-1]<=0)
				throw TeGlobalBayesException(BAYES_NULL_POPULATION);
		}

		m_hat = sum_y/sum_n;
		n_	  = sum_n/Narea;

		for(count=0;count<Narea;count++)
		{
			s2+= n[count]*(r[count]-m_hat)*(r[count]-m_hat);
		}
		s2=s2/sum_n;

		it = rs->begin();
		aux = s2 - (m_hat/n_);
	
		if(aux<0)
		{
			(*it).setDoubleProperty(2,m_hat);
			++it;
		}
		else
		{
 			double Theta_i, Ci, pop, cases;
			while(it != rs->end())
			{
				(*it).getDoubleProperty(0,pop);
				(*it).getDoubleProperty(1,cases);
				Ci = (aux)/(aux + (m_hat/pop));
				Theta_i = Ci*(cases/pop) + (1-Ci)*m_hat;
				(*it).setDoubleProperty(2,Theta_i*rate);
				++it;
			}
		}

	}catch(TeGlobalBayesException e)
		{
/*			switch(e.getErrorCode()){
			case BAYES_GREATER_CASES:
			break;
			case BAYES_NULL_POPULATION:
			break;
			}*/
      e.getErrorCode();
			return(false);
		}

	return(true);
}



/* Taxa Bayesiana Local -- recebe conjunto de areas, cria matriz de vizinhanca,
   e estima taxa local baseado na vizinhanca.

   As duas primeiras propriedades das areas sao populacao e casos.
   Ha mais duas propriedades double onde serao armazenados total de casos e total
   de populacao dos vizinhos.

  teta[i]=w[i]*r[i]+(1-w[i])*c[i]
  w[i]=V/(V+r[i]))
  V=Sum(Area i,Pop[i]*(ri-m)^2)/Sum(Area i,Pop[i])-m/PopMedia
*/
// TeGlobalEmpiricalBayes				// Function declaration
bool TeLocalEmpiricalBayes(TeSTElementSet *rs, string& colname, double /*rate*/)
{


  //Monta vizinhanca
	TeProxMatrixLocalAdjacencyStrategy matrix(rs, TePOLYGONS);         
	TeGeneralizedProxMatrix neighMatrix(&matrix);

  //Percorre areas, calculando populacao e contagem total dos vizinhos

  TeSTElementSet::iterator it = rs->begin(); 
	double neiPop, neiCases;
  double totPop, mPop;

  totPop = 0;
  std::string val;

	while ( it != rs->end())
	{
		
    //Inicializa total de casos e de populacao
    neiPop = neiCases = 0;
    (*it).getPropertyValue(val, 0);
    mPop = atof(val.c_str());
    if (mPop == 0)
      return false;
    totPop += mPop;


		TeNeighboursMap  neighbors = neighMatrix.getMapNeighbours((*it).objectId());

    if (neighbors.size() > 0) {

      TeNeighboursMap::iterator itNeigs = neighbors.begin();
      
      //Total de casos e de populacao
      while(itNeigs != neighbors.end()){
        
        //Pega numero de casos e de populacao
        it.elemSet()->getAttributeValue((*itNeigs).first, 0, val);
        neiPop += atof(val.c_str());
        it.elemSet()->getAttributeValue((*itNeigs).first, 1, val);
        neiCases += atof(val.c_str());
        (++itNeigs);
      }
    }

    //Insere propriedades na area
    
    TeProperty prop;
    prop.attr_.rep_.type_ = TeREAL;

    prop.attr_.rep_.name_ = "neiPop";
    prop.value_ = Te2String(neiPop, 9);
    (*it).addProperty(prop);

    prop.attr_.rep_.name_ = "neiCases";
    prop.value_ = Te2String(neiCases, 9);
    (*it).addProperty(prop);

    (++it);
  }       


  double m, variance, V, W, LocalBayesRate;
  double myPop, myCases, neiJPop, neiJCases;

  TeProperty rateProp;
  rateProp.attr_.rep_.type_ = TeREAL;
  rateProp.attr_.rep_.name_ = colname;

  it = rs->begin(); 
	while ( it != rs->end())
	{

    //Pega numero de casos e de populacao
    (*it).getPropertyValue(val, 0);
    myPop = atof(val.c_str());
    (*it).getPropertyValue(val, 1);
    myCases = atof(val.c_str());

    (*it).getPropertyValue("neiPop", val);
    neiPop = atof(val.c_str());
    (*it).getPropertyValue("neiCases", val);
    neiCases = atof(val.c_str());

    m = (double)neiCases/(double)neiPop;
    variance = 0;

    TeNeighboursMap  neighbors = neighMatrix.getMapNeighbours((*it).objectId());
      
    if (neighbors.size() == 0) {
       LocalBayesRate = (double)myCases/(double)myPop;
    }
    else {

      TeNeighboursMap::iterator itNeigs = neighbors.begin();

      //Total de casos e de populacao
      while(itNeigs != neighbors.end()){
        
        //Pega numero de casos e de populacao
        it.elemSet()->getAttributeValue((*itNeigs).first, 0, val);
        neiJPop = atof(val.c_str());
        it.elemSet()->getAttributeValue((*itNeigs).first, 1, val);
        neiJCases = atof(val.c_str());

        //Atualiza numS
        variance += (double)neiJPop * pow((double)neiJCases/(double)neiJPop - m,2);
        (++itNeigs);
      }
   

      V = (variance/(double)myPop) - (m * (double)neighbors.size()/(double)neiPop);
      if (V < 0)
        V = 0;
      W = V/(V + (m/(double)myPop));
      LocalBayesRate = W * (double)myCases/(double)myPop + (1 - W) * m;

    }
    rateProp.value_ = Te2String(LocalBayesRate, 9);
    (*it).addProperty(rateProp);
    (++it);
  }       

  return (true);
}
