/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
/*! \file TeDecoderSPR.h
    This file deals with decoding of raster data in a ASCII SPRING format
*/
#ifndef  __TERRALIB_INTERNAL_DECODERSPR_H
#define  __TERRALIB_INTERNAL_DECODERSPR_H

#include "TeDecoderMemory.h"

class TeAsciiFile;

//! Implements a decoder for rasters in ASCII Spring format
class TeDecoderSPR : public TeDecoderMemory
{
public:
	//! Empty constructor
	TeDecoderSPR () : TeDecoderMemory() 
	{	params_.decoderIdentifier_ = "SPR";	}

	//! Constructor from some parameters
	TeDecoderSPR (const TeRasterParams& par);

	//! Destructor
	~TeDecoderSPR ();

	void	init();
	bool	clear();
private:
    bool    readFile(const string& filename);
	bool	readParameters();
	bool	writeParameters(TeAsciiFile& pFile);
	bool	saveData(TeAsciiFile& pFile);
};

//! Implements a factory to build decoders to JPEG raster
class TeDecoderSPRFactory : public TeDecoderFactory
{
public:

	TeDecoderSPRFactory(const string& name) : TeDecoderFactory(name) {}

	virtual TeDecoder* build (const TeRasterParams& arg)
	{  return new TeDecoderSPR(arg); }

};

#endif
