/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
/*! \file TeDecoderMemoryMap.h
    This file deals with decoding of raster data in a bynary file, using the memory map operation system functionality
*/
#ifndef  __TERRALIB_INTERNAL_DECODERMEMORYMAP_H
#define  __TERRALIB_INTERNAL_DECODERMEMORYMAP_H

#include "TeDecoder.h"

#ifdef WIN32
#include <windows.h>
#include <winbase.h>
#else
#include <sys/mman.h>
#endif

 
//! Implements a decoder to raster data in a bynary file, using the memory map operation system functionality
class TeDecoderMemoryMap : public TeDecoder
{
public:
	TeDecoderMemoryMap ( const TeRasterParams& );
	~TeDecoderMemoryMap ();

	bool setElement (int col, int lin, double val, int band = 0);
	bool getElement (int col, int lin, double &val,int band = 0);

	void init	();
	bool clear	();

	void writeMetadataFile();
	void readMetadataFile();

private:
	bool create	();

#ifdef WIN32
// Windows support to file memory mapping
	long	dataInitPos_;
	HANDLE  m_hFile;			// Handle to file we're currently zapping
	HANDLE	m_hMapping;			// Handle to memory-mapping of that file
	LPVOID  m_lpszFile;			// Pointer to view of file mapped to memory
	DWORD	m_dwSize;
#else
// Linux support to file memory mapping
	long	dataInitPos_;
	int  m_hFile;			//(fd) Handle to file we're currently zapping
	void*  m_lpszFile;			// Pointer to view of file mapped to memory
	long	m_dwSize;
#endif
};

//! Implements a factory to build memory map decoder
class TeDecoderMemoryMapFactory : public TeDecoderFactory
{
public:

	TeDecoderMemoryMapFactory(const string& name) : TeDecoderFactory(name) {}

	virtual TeDecoder* build (const TeRasterParams& arg)
	{  return new TeDecoderMemoryMap(arg); }
};
#endif

