#include "TeSTEFunctionsSHP.h"
#include "TeSTElementSet.h"
#include <vector>

#include "shapefil.h"

bool TeDecodeShape(SHPObject* psShape, TePointSet& ps,const string& objectId);
bool TeDecodeShape(SHPObject* psShape, TeLineSet& ps,const string& objectId);
bool TeDecodeShape(SHPObject* psShape, TePolygonSet& ps,const string& objectId);

bool TeDecodeShape(SHPObject* psShape, TeMultiGeometry& geomestries, const string& objectId)
{
	int shpType = psShape->nSHPType;
	switch (shpType)
	{
		case SHPT_POLYGON:
		case SHPT_POLYGONZ:
			return TeDecodeShape(psShape,geomestries.polygons_,objectId);
		case SHPT_ARC:
		case SHPT_ARCZ:
			return TeDecodeShape(psShape,geomestries.lines_,objectId);
		case SHPT_POINT:
		case SHPT_POINTZ:
		case SHPT_MULTIPOINT:
		case SHPT_MULTIPOINTZ:
			return TeDecodeShape(psShape,geomestries.points_,objectId);
	}
	return false;
}

bool TeReadDBFAttributeList(const string& dbfFileName, TeAttributeList& attList);

bool
TeSTOSetBuildSHP(TeSTElementSet& stoset, const string& fileName)
{
	// Read some information about the shapefile
	string filePrefix = TeGetName(fileName.c_str());
	string shpfileName = filePrefix + ".shp";

	SHPHandle	hSHP;
	hSHP = SHPOpen( shpfileName.c_str(), "rb" );

	if( hSHP == 0 )
		return false;

	int		nShapeType, nEntities;
	double 	adfMinBound[4], adfMaxBound[4];

	SHPGetInfo(hSHP, &nEntities, &nShapeType, adfMinBound, adfMaxBound);

	string dbffileName = filePrefix + ".dbf";
    DBFHandle hDBF = DBFOpen( dbffileName.c_str(), "rb" );
    if( hDBF == 0  || DBFGetFieldCount(hDBF) == 0)
		return false;
    
	int natt = DBFGetFieldCount(hDBF);
	TeAttributeList attList;
	TeReadDBFAttributeList(shpfileName, attList);

	TeAttributeRep repobjid;
	repobjid.name_ = "object_id";
	repobjid.numChar_ = 16;

	TeAttribute attobjid;
	attobjid.rep_ = repobjid;

	TeProperty propobjid;
	propobjid.attr_ = attobjid;
	
	int i,n;
	SHPObject* psShape;
	for (i=0; i<nEntities; i++)
	{
		string objectid = Te2String(i);
		TeSTInstance curObj;
		curObj.objectId(objectid);
		TeSTElement objInstances;
		objInstances.objectId(objectid);

		TePropertyVector prop;
		psShape = SHPReadObject(hSHP,i);
		if (TeDecodeShape(psShape,curObj.geometries(),objectid))
		{
			propobjid.value_ = objectid;
			prop.push_back(propobjid);
			for(n=0;n<natt;n++)
			{
				string value = DBFReadStringAttribute(hDBF,i,n);
				TeProperty p;
				p.attr_ = attList[n];
				p.value_ = value;
				prop.push_back(p);
			}
			curObj.properties(prop);
			objInstances.insertSTInstance(curObj);
			stoset.insertSTElement(objInstances);
			curObj.theme(0);
		}
		SHPDestroyObject(psShape);
	}
	return true;
} 

bool TeDecodeShape(SHPObject* psShape, TePointSet& points,const string& objectId)
{
	int i;
	for (i = 0; i < ( psShape->nVertices ); i++ )
	{
		TePoint point;
		TeCoord2D xy ( psShape->padfX[i], psShape->padfY[i] );
		point.add ( xy );
		point.objectId(objectId);
		points.add ( point );
	}
	return (i > 0);
}

bool TeDecodeShape(SHPObject* psShape, TeLineSet& lines, const string& objectId)
{
	vector<int> partStart;
	int iPart;
	for (iPart = 0; iPart < psShape->nParts; iPart++ )
		partStart.push_back ( psShape->panPartStart[iPart] );
	partStart.push_back ( psShape->nVertices ); // point to the end

	iPart = 0;
	int j = 0; 
	while ( j < psShape->nVertices )
	{
		TeLine2D line;

		iPart++;  // indicates the different segments of the line
		while ( j < partStart[iPart] )	// Read each segment
		{
			TeCoord2D pt ( psShape->padfX[j], psShape->padfY[j] );
			line.add ( pt );
			j++;
		}
		line.objectId(objectId);
		lines.add(line);
	}
	return (iPart > 0);

}

bool TeDecodeShape(SHPObject* psShape, TePolygonSet& polys, const string& objectId)
{
	int iPart, j;
	vector<int> partStart;
	list<TePolygon> pList;

	// Build an array whose components point to the starting point
	// of the rings that compose the shapepoly
	for ( iPart = 0; iPart < psShape->nParts; iPart++ )
		partStart.push_back ( psShape->panPartStart[iPart] );
	partStart.push_back ( psShape->nVertices ); // point to the end

	iPart = 0;
	j = 0;
	while ( j < psShape->nVertices )
	{
		iPart++;						// indicates the different rings of the shapepoly
		TeLine2D line;
		while ( j < partStart[iPart] )	// Read each ring
		{
			TeCoord2D pt ( psShape->padfX[j], psShape->padfY[j] );
			line.add ( pt );
			j++;
		}	// end of a ring
		if (!line.isRing())
			line.add(line[0]);

		TeLinearRing ring(line);
		bool inside = false;		// Is it an OUTER or an INNER RING ?

		list<TePolygon>::iterator it = pList.begin();
		// Each ring is assigned to a polygon
		// Each ring and polygon have a unique "geometrical index"
		//
		// All rings and polygons that are part of a same object
		// have the same "object index"

		while ( it != pList.end() )
		{
			TePolygon aux;
			aux.add(ring);
			if (TeWithin(aux,(*it)))
			{
				inside = true;
				ring.objectId ( (*it)[0].objectId() );	// sets the object index
				(*it).add ( ring );						// add a closed region
				break;
			}
			++it;
		}
		if (!inside)
		{
			TePolygon poly;
			ring.objectId (objectId);
			poly.add(ring);						// add an outer region
			poly.objectId(objectId);			// set the object index

			pList.push_back ( poly );
		}
	}
	list<TePolygon>::iterator it = pList.begin();
	while ( it != pList.end() )
	{
		polys.add(*it);
		++it;
	}
	return (iPart > 0);
}

