/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#include "TeThemeApplication.h"
#include "TeUtils.h"
#include "TeDatabase.h"
#include "TeDatabaseUtils.h"


unsigned int TeThemeApplication::getTableIndexFromField(string fieldName)
{
	unsigned int i, n, index;
	index = 0;
	n = attTableVector_[0].attributeList().size();
	for (i = 0; i < sqlAttList_.size(); ++i)
	{
		if (i > n - 1)
		{
			++index;
			n += attTableVector_[index].attributeList().size();
		}

		if (sqlAttList_[i].rep_.name_ == fieldName)
			break;
	}
	return index;
}



bool TeThemeApplication::locateText (TeCoord2D &pt, TeText &text, const double& tol)
{
	TeDatabasePortal* portal = layer()->database()->getPortal();
	string table = textTable();

	TeBox box (pt.x()-tol,pt.y()-tol,pt.x()+tol,pt.y()+tol);
	string q = "SELECT " + table + ".* FROM " + table + ", " + collectionTable();
	char buf [1024];
	sprintf (buf," WHERE c_object_id = object_id AND (x < %f AND x > %f AND y < %f AND y > %f)",
		box.x2(),box.x1(),box.y2(),box.y1());
	q += buf;
	if (!portal->query(q) || !portal->fetchRow())
	{
		delete portal;
		return false;
	}
	// Look for all texts
	bool flag = true;
	TeTextSet ts;
	do
	{
		TeText p;
		flag = portal->fetchGeometry(p);
		ts.add ( p );
	} while (flag);

	delete portal;

	int k;
	if (TeNearest (pt, ts, k, tol))
	{
		text = ts[k];
		return true;
	}
	return false;
}

TeVisual TeThemeApplication::getTextVisual(const TeText &text)
{
	int	dot_height, rgb;
	string family;
	string table = textTable() + "_txvisual";
	bool fix_size = false, bold = false, italic = false;
	TeDatabase* db = layer()->database();

	string sel = "SELECT dot_height, fix_size, color, family, bold, italic FROM ";
	sel += table + " WHERE geom_id = " + Te2String(text.geomId());

	TeDatabasePortal* portal = db->getPortal();
	if(portal->query(sel))
	{
		if(portal->fetchRow())
		{
			dot_height = atoi(portal->getData(0));
			if(atoi(portal->getData(1)))
				fix_size = true;
			rgb = atoi(portal->getData(2));
			family = portal->getData(3);
			if(atoi(portal->getData(4)))
				bold = true;
			if(atoi(portal->getData(5)))
				italic = true;
		}
	}
	delete portal;
	TeColor	cor((rgb >> 16) & 0xff, (rgb >> 8) & 0xff, rgb & 0xff);
	TeVisual visual;
	visual.size(dot_height);
	visual.fixedSize(fix_size);
	visual.color(cor);
	visual.family(family);
	visual.bold(bold);
	visual.italic(italic);

	return visual;
}


string TeThemeApplication::getLegendTitleAlias()
{
	string text;

	TeLegendEntryVector& legendVector = legend();
	if (legendVector.size() > 0)
	{
		TeDatabase* database = layer()->database();
		TeAttributeRep rep; 
		string nattr;
		if(grouping())
		{
			rep = grouping()->groupAttribute_; 
			nattr = grouping()->groupNormAttribute_;
		}
		text = rep.name_;
		map<int, map<string, string> >::iterator it = database->mapThemeAlias().find(id());
		if(it != database->mapThemeAlias().end())
		{
			map<string, string>& m = it->second;
			map<string, string>::iterator tit = m.find(text);
			if(tit != m.end())
				text = tit->second;
			if(!(nattr.empty() || nattr == "NONE"))
			{
				tit = m.find(nattr);
        		if(tit != m.end()) {
        		  if (!tit->second.empty()) {
					text += "/" + tit->second;
          		  }
        		}
        		else  //Deixando ficar sem barra 
					text += "/" + nattr;
			}
		}
	}
	return text;
}

string TeThemeApplication::	getPieBarAlias(string atr)
{
	string text;

	if (chartAttributes_.size() > 0)
	{
		TeDatabase* database = layer()->database();
		map<int, map<string, string> >::iterator it = database->mapThemeAlias().find(id());
		if(it != database->mapThemeAlias().end())
		{
			map<string, string>& m = it->second;
			map<string, string>::iterator tit = m.find(atr);
			if(tit != m.end())
				text = tit->second;
		}
	}
	return text;
}

bool TeThemeApplication::setAlias(string attr, string attAlias)
{
	TeDatabase* db = layer()->database();
	map<int, map<string, string> >& mapThemeAlias = db->mapThemeAlias();
	map<string, string>& mapAA = mapThemeAlias[id()];
	map<string, string>::iterator it = mapAA.begin();

	while(it != mapAA.end())
	{
		if(it->first != attr && it->second == attAlias)
			return false;
		it++;
	}

	int f = attr.find("/");
	int af = attAlias.find("/");
	if(f >= 0 && af >= 0)
	{
		string nattr = attr;
		attr.erase(f, attr.size()-f);
		nattr.erase(0, f+1);

		string alias = attAlias;
		string nalias = alias;
		alias.erase(af, alias.size()-af);
		nalias.erase(0, af+1);

		mapAA[attr] = alias;
		mapAA[nattr] = nalias;
		updateThemeApplication (db, this);
		return true;
	}
	else
	{
    	//Alterando para deixar ficar sem /
    	if(f >= 0) {
      		string nattr = attr;
      		nattr.erase(0, f+1);
      		mapAA[nattr] = "";
			attr.erase(f, attr.size()-f);
    	}
		mapAA[attr] = attAlias;
		updateThemeApplication (db, this);
		return true;
	}
}

void TeThemeApplication::removeAlias(string attribute)
{
	string attr = attribute;
	string nattr = attr;
	TeDatabase* db = layer()->database();
	map<int, map<string, string> >& mapThemeAlias = db->mapThemeAlias();
	map<string, string>& mapAA = mapThemeAlias[id()];

	int f = attr.find("/");
	if(f >= 0)
	{
		attr.erase(f, attr.size()-f);
		nattr.erase(0, f+1);
	}
	map<string, string>::iterator it = mapAA.find(attr);
	if(it != mapAA.end())
	{
		mapAA.erase(it);
		if(mapAA.size() == 0)
		{
			map<int, map<string, string> >::iterator tit = mapThemeAlias.find(id());
			if(tit != mapThemeAlias.end())
				mapThemeAlias.erase(tit);
		}
	}
	if(nattr != attr)
	{
		map<string, string>::iterator it = mapAA.find(nattr);
		if(it != mapAA.end())
		{
			mapAA.erase(it);
			if(mapAA.size() == 0)
			{
				map<int, map<string, string> >::iterator tit = mapThemeAlias.find(id());
				if(tit != mapThemeAlias.end())
					mapThemeAlias.erase(tit);
			}
		}
	}

	updateThemeApplication (db, this);
}

void TeThemeApplication::removeAllAlias()
{
	TeDatabase* db = layer()->database();
	map<int, map<string, string> >& mapThemeAlias = db->mapThemeAlias();
	map<int, map<string, string> >::iterator it = mapThemeAlias.find(id());
	if(it != mapThemeAlias.end())
		mapThemeAlias.erase(it);
	updateThemeApplication (db, this);
}

void TeThemeApplication::concatTableName(string& attr)
{
	string tableName;

	if(attr.find(".") == attr.npos)
	{
		TeAttrTableVector::iterator it = attTableVector_.begin();

		while(it != attTableVector_.end())
		{
			TeTable	t = *it;
			TeAttributeList AL = t.attributeList();
			TeAttributeList::iterator iit = AL.begin();

			while(iit != AL.end())
			{
				if((*iit).rep_.name_ == attr)
				{
					tableName = (*it).name();
					break;
				}
				iit++;
			}

			if(tableName.empty() == false)
			{
				tableName += ".";
				attr.insert(0, tableName);
				break;
			}
			it++;
		}
	}
}



int TeThemeApplication::numObjects() {

  int numRows;

  string s = "SELECT COUNT(*) " + sqlFrom();	
  TeDatabasePortal* portal = layer_->database()->getPortal();
  if(portal->query(s))
  {
    if(portal->fetchRow())
    {
      numRows = atoi(portal->getData(0));
    }
  }
  
  delete portal;
  return numRows;
  
}

TeBox TeThemeApplication::boundingBox() {
    return layer_->database()->getThemeBox(this);
}
