#include "TeGUIUtils.h"
#include <TeViewNode.h>
#include <TeThemeApplication.h>

bool fillThemeCombo(TeGeomRep tg, TeView* view, QComboBox* cBox, string selName, bool clear)
{
	vector<TeViewNode *> themeVec = view->themes();
//	bool enableWindow = false;
	
	if (clear)
		cBox->clear();
	
	int idx = 0;
	int count = 0;
	
	for(unsigned int i=0; i<themeVec.size(); i++)
	{
		TeThemeApplication* t = (TeThemeApplication *)themeVec[i];
		if(t->layer()->hasGeometry(tg))
		{
			cBox->insertItem(t->name().c_str());
			if (!t->name().compare(selName)) {
				idx = count;
			}
			count++;
		}
	}
  
	if (count > 0) {
		cBox->setCurrentItem(idx);
	}
	
	return (count > 0);
}


bool fillTableCombo(TeView* view,
                     QComboBox *cTableCombo, 
                     QComboBox *cThemeCombo,
                     string selName, bool clear)
{
	TeTable ttable;
	string tableName;
	string themeName =  string(cThemeCombo->currentText().ascii());
	TeTheme* currTheme = view->get(themeName);

	if (currTheme == NULL) 
		return false;

	TeAttrTableVector atvec;
  currTheme->getAttTables(atvec);
	
	if (atvec.size() == 0)
		return false;

	if (clear)
		cTableCombo->clear();
	int idx = 0;
	
	for(unsigned int i=0; i<atvec.size(); i++)
	{
		TeTable ttable = atvec[i];
		tableName = ttable.name();
		cTableCombo->insertItem(tableName.c_str());
		if (!selName.compare(tableName)) {
			idx = i;
		}
	}
	
	cTableCombo->setCurrentItem(idx);
	return true;
}


bool fillColumnCombo(TeAttrDataType aType,
                      TeTheme* theme,
                      QComboBox *cColumnCombo, 
                      QComboBox *cTableCombo,
                      string selName, bool clear) {

//	bool done = false;
  
	TeAttributeList columns;
	TeAttrTableVector atvec;
  theme->getAttTables(atvec);

	string tableName = string(cTableCombo->currentText().ascii());
	unsigned int t;

	for (t = 0; t < atvec.size(); t++) {
		if (!tableName.compare(atvec[t].name()))
			break;
	}
	
	if (t == atvec.size())
		return false;

	TeTable ttable = atvec[t];
	columns = ttable.attributeList();
	
	if (clear)
		cColumnCombo->clear();
	
	int idx = 0;
	int count = 0;
	
	for(unsigned int i=0; i<columns.size(); i++)
	{
		int type = columns[i].rep_.type_;
		string colName = columns[i].rep_.name_;	
		if ((aType == TeUNKNOWN) || (type == aType)) {
			cColumnCombo->insertItem(colName.c_str());
			if (!selName.compare(colName)) {
				idx = count;
			}
			count++;
		}
	}
	
	if (count > 0) 
		cColumnCombo->setCurrentItem(idx);
	
	return count> 0;
}

bool fillColumnCombo(vector<TeAttrDataType> &aTypeVec,
                      TeTheme* theme,
                      QComboBox *cColumnCombo, 
                      QComboBox *cTableCombo,
                      string selName, bool clear)
{
	bool result = true;
	
	for(unsigned int i = 0; i < aTypeVec.size(); i++)
	{
		result = fillColumnCombo(aTypeVec[i], theme, cColumnCombo, cTableCombo, selName, clear);
		if(!result)
			return false;
	}
	return true;
}
