#ifndef TEPDISHAREDPTR_CPP
#define TEPDISHAREDPTR_CPP

#include "TePDISharedPtr.hpp"

#include <iostream>


template< class T >
TePDISharedPtr< T >::TePDISharedPtr( T* pointer,
  bool static_assignment )
{
  if( pointer == 0 ) {
    counter_ = 0;
    reference_ = 0;
    static_assignment_ = false;
  } else {
    counter_ = new unsigned long int;
    (*counter_) = 1;

    reference_ = pointer;

    static_assignment_ = static_assignment;
  }
}


template< class T >
TePDISharedPtr< T >::TePDISharedPtr( const TePDISharedPtr& external )
{
  counter_ = 0;
  reference_ = 0;
  static_assignment_ = false;

  (*this) = external;
}


template< class T >
  TePDISharedPtr< T >::~TePDISharedPtr()
{
  reset();
}


template< class T >
bool TePDISharedPtr< T >::isActive() const
{
  return ( reference_ == 0 ) ? false : true;
}


template< class T >
void TePDISharedPtr< T >::reset( T* pointer, bool static_assignment )
{
  if( isActive() ) {
     --(*counter_);

     if( (*counter_) == 0 ) {
       delete counter_;

       if( ! static_assignment_ ) {
         delete reference_;
       }
     }
  }

  if( pointer != 0 ){
    counter_ = new unsigned long int;
    (*counter_) = 1;

    reference_ = pointer;

    static_assignment_ = static_assignment;
  } else {
    counter_ = 0;
    reference_ = 0;
    static_assignment_ = false;
  }
}


template< class T >
TePDISharedPtr< T >& TePDISharedPtr< T >::operator=(
  const TePDISharedPtr< T >& external )
{
  reset();

  if( external.isActive() ) {
    counter_ = external.counter_;
    (*counter_) = (*counter_) + 1;

    reference_ = external.reference_;

    static_assignment_ = external.static_assignment_;
  }

  return *this;
}


template< class T >
T& TePDISharedPtr< T >::operator*()
{
  if( ! isActive() ) {
    std::cout << std::endl
      << "TePDISharedPtr::operator* - Invalid use of inactive instance"
      << std::endl;
    throw;
  }

  return *reference_;
}


template< class T >
T* TePDISharedPtr< T >::operator->()
{
  return reference_;
}


template< class T >
bool TePDISharedPtr< T >::operator==( const TePDISharedPtr& external )
{
  return ( ( reference_ == external.reference_ ) &&
         ( counter_ == external.counter_ ) ) ? true : false;
}


template< class T >
bool TePDISharedPtr< T >::operator!=( const TePDISharedPtr& external )
{
  return ( ( reference_ != external.reference_ ) ||
    ( counter_ != external.counter_ ) ) ? true : false;
}


template< class T >
T* TePDISharedPtr< T >::NakedPointer()
{
  return reference_;
}


#endif //TEPDISHAREDPTR_CPP
