/*
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular
purpose. The library provided hereunder is on an "as is" basis, and the
authors have no obligation to provide maintenance, support, updates,
enhancements, or modifications.
In no event shall INPE be held liable to any party
for direct, indirect, special, incidental, or consequential damages arising
out of the use of this library and its documentation.
*/

#ifndef TEPDIFILTER_HPP
  #define TEPDIFILTER_HPP

  #include "TePDIAlgorithm.hpp"
  #include "TePDIParameters.hpp"

  #include "TePDISharedPtr.cpp"

  /**
   *   This is the base class for image filtering algorithms.
   */
  class TePDIFilter : public TePDIAlgorithm{
    public :
      typedef TePDISharedPtr< TePDIFilter > pointer;
      typedef const TePDISharedPtr< TePDIFilter > const_pointer;

      /**
       * Default Destructor
       */
      ~TePDIFilter();

      /**
       * Checks if the supplied parameters fits the requirements of each
       * PDI algorithm implementation.
       *
       * Error log messages must be generated. No exceptions generated.
       *
       * @param parameters The parameters to be checked.
       * @return true if the parameters are OK. false if not.
       */
      virtual bool CheckParameters( const TePDIParameters& parameters ) = 0;

    protected :
      /**
       * Default Constructor.
       *
       */
      TePDIFilter();

      /**
       * Alternative Constructor
       *
       * @param params Algoritm parameters.
       */
      TePDIFilter( const TePDIParameters& params );

      /**
       * Runs the current algorithm implementation.
       *
       * @return true if OK. false on error.
       */
      virtual bool RunImplementation() = 0;

      /**
       * Reset the internal state to the initial state.
       */
      virtual void ResetState() = 0;

  };

#endif //TEPDIFILTER_HPP
