/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ReadOnlyIterator;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public abstract class AbstractObjectDescription
implements ObjectDescription,
Cloneable {
    private Class className;
    private HashMap parameters;
    private HashMap parameterDefs;
    private Configuration config;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public AbstractObjectDescription(Class className) {
        this.className = className;
        this.parameters = new HashMap();
        this.parameterDefs = new HashMap();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        this.config = config;
    }

    public static Class convertPrimitiveClass(Class obj) {
        if (!obj.isPrimitive()) {
            return obj;
        }
        if (obj == Boolean.TYPE) {
            return class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = AbstractObjectDescription.class$("java.lang.Boolean"));
        }
        if (obj == Byte.TYPE) {
            return class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = AbstractObjectDescription.class$("java.lang.Byte"));
        }
        if (obj == Character.TYPE) {
            return class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = AbstractObjectDescription.class$("java.lang.Character"));
        }
        if (obj == Short.TYPE) {
            return class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = AbstractObjectDescription.class$("java.lang.Short"));
        }
        if (obj == Integer.TYPE) {
            return class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = AbstractObjectDescription.class$("java.lang.Integer"));
        }
        if (obj == Long.TYPE) {
            return class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = AbstractObjectDescription.class$("java.lang.Long"));
        }
        if (obj == Float.TYPE) {
            return class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = AbstractObjectDescription.class$("java.lang.Float"));
        }
        if (obj == Double.TYPE) {
            return class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = AbstractObjectDescription.class$("java.lang.Double"));
        }
        throw new IllegalArgumentException("Class 'void' is not allowed here");
    }

    public abstract Object createObject();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractObjectDescription)) {
            return false;
        }
        AbstractObjectDescription abstractObjectDescription = (AbstractObjectDescription)o;
        return this.className.equals(abstractObjectDescription.className);
    }

    public Configuration getConfig() {
        return this.config;
    }

    protected Iterator getDefinedParameterNames() {
        return new ReadOnlyIterator(this.parameters.keySet().iterator());
    }

    public ObjectDescription getInstance() {
        try {
            AbstractObjectDescription c = (AbstractObjectDescription)super.clone();
            c.parameters = (HashMap)this.parameters.clone();
            return c;
        }
        catch (Exception e) {
            Log.error((Object)"Should not happen: Clone Error: ", (Exception)e);
            return null;
        }
    }

    public Class getObjectClass() {
        return this.className;
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public Class getParameterDefinition(String name) {
        return (Class)this.parameterDefs.get(name);
    }

    public synchronized Iterator getParameterNames() {
        ArrayList parameterNames = new ArrayList(this.parameterDefs.keySet());
        Collections.sort(parameterNames);
        return new ReadOnlyIterator(((AbstractList)parameterNames).iterator());
    }

    public ObjectDescription getUnconfiguredInstance() {
        try {
            AbstractObjectDescription c = (AbstractObjectDescription)super.clone();
            c.parameters = (HashMap)this.parameters.clone();
            c.config = null;
            return c;
        }
        catch (Exception e) {
            Log.error((Object)"Should not happen: Clone Error: ", (Exception)e);
            return null;
        }
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public void setParameter(String name, Object value) {
        if (this.getParameterDefinition(name) == null) {
            throw new IllegalArgumentException("No such Parameter defined: " + name + " in class " + this.getObjectClass());
        }
        Class parameterClass = AbstractObjectDescription.convertPrimitiveClass(this.getParameterDefinition(name));
        if (!parameterClass.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("In Object " + this.getObjectClass() + ": Value is not assignable: " + value.getClass() + " is not assignable from " + parameterClass);
        }
        this.parameters.put(name, value);
    }

    public void setParameterDefinition(String name, Class obj) {
        if (obj == null) {
            this.parameterDefs.remove(name);
        } else {
            this.parameterDefs.put(name, obj);
        }
    }

    public abstract void setParameterFromObject(Object var1) throws ObjectFactoryException;
}

