/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/inti.h
//! @brief The main Inti header file.

//! @defgroup inti_group The Inti Namespace
//! @namespace Inti
//! @brief Primary Namespace.

//! @defgroup i18n_group The Internationalization Namespace
//! @namespace Inti::i18n
//! @ingroup inti_group
//! @brief Internationalization and Localization.
//!
//! Provides a C++ interface to GNU gettext for
//! Internationalization and Localization support.

//! @defgroup main_group The Main Namespace
//! @namespace Inti::Main
//! @ingroup inti_group
//! @brief Initialization, main event loop and events.
//!
//! Provides a set of methods and signals for handling program
//! initialization and custom event loop processing.

//! @defgroup atk_group The Atk Namespace
//! @namespace Inti::Atk
//! @ingroup inti_group
//! @brief C++ framework the ATK Accessibility Toolkit.
//!
//! Provides a set of generic interfaces allowing accessibility
//! technologies to interact with a graphical user interface.
//! For example, a screen reader uses ATK to discover the text
//! in an interface and read it to blind users. GTK+ widgets have
//! built-in support for accessibility using the ATK framework.

//! @defgroup gdk_group The Gdk Namespace
//! @namespace Inti::Gdk
//! @ingroup inti_group
//! @brief C++ framework for the GTK+ Drawing Kit and the GdkPixbuf library.
//!
//! Provides an API that can be used to add two-dimensional graphics
//! to your program. GDK itself is the abstraction layer that allows
//! GTK+ to support multiple windowing systems. GDK provides drawing
//! and window system facilities on X11, Windows, and the Linux 
//! framebuffer device.

//! @defgroup g_group The G Namespace
//! @namespace Inti::G
//! @ingroup inti_group
//! @brief C++ framework for the GObject and GLib libraries.
//!
//! Implements the object API that provides the base classes for the
//! entire Inti library. Also wraps several of GLIB utility classes.

//! @defgroup gtk_group The Gtk Namespace
//! @namespace Inti::Gtk
//! @ingroup inti_group
//! @brief C++ framework for the GTK GUI library.
//!
//! Provides a set of graphical objects called widgets which serve as
//! the GUI component, such as Gtk::Button and Gtk::Textview.

//! @defgroup pango_group The Pango Namespace
//! @namespace Inti::Pango
//! @ingroup inti_group
//! @brief C++ framework for the Pango text handling library.
//!
//! Pango is a library for internationalized text handling. It centers
//! around the Pango::Layout object, representing a paragraph of text.
//! Pango provides the engine for Gtk::TextView, Gtk::Label, Gtk::Entry
//! and other widgets that display text.

#ifndef INTI_H
#define INTI_H

// Inti version.

extern const unsigned int inti_major_version;
//!< libinti major version  number.

extern const unsigned int inti_minor_version;
//!< libinti minor version  number.

extern const unsigned int inti_micro_version;
//!< libinti micro version  number.

#endif // INTI_H

