/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
//! @file inti/gtk/separatormenuitem.h
//! @brief A GtkSeparatorMenuItem C++ wrapper interface.
//!
//! Provides SeparatorMenuItem, a separator used to group items within a menu.

#ifndef INTI_GTK_SEPARATOR_MENU_ITEM_H
#define INTI_GTK_SEPARATOR_MENU_ITEM_H

#ifndef INTI_GTK_MENU_ITEM_H
#include <inti/gtk/menuitem.h>
#endif

#ifndef __GTK_SEPARATOR_MENU_ITEM_H__
#include <gtk/gtkseparatormenuitem.h>
#endif

namespace Inti {

namespace Gtk {

class SeparatorMenuItemClass;

//! @class SeparatorMenuItem separatormenuitem.h inti/gtk/separatormenuitem.h
//! @brief A GtkSeparatorMenuItem C++ wrapper class.
//!
//! The SeparatorMenuItem is a separator used to group items within a menu. It displays
//! a horizontal line with a shadow to make it appear sunken into the interface.

class SeparatorMenuItem : public MenuItem
{
	friend class G::Object;
	friend class SeparatorMenuItemClass;
	
	SeparatorMenuItem(const SeparatorMenuItem&);
	SeparatorMenuItem& operator=(const SeparatorMenuItem&);
	
protected:
//! @name Constructors
//! @{

	explicit SeparatorMenuItem(GtkSeparatorMenuItem *menu_item, bool reference = false);
	//!< Construct a new SeparatorMenuItem from an existing GtkSeparatorMenuItem.
	//!< @param menu_item A pointer to a GtkSeparatorMenuItem.
	//!< @param reference Set false if the initial reference count is floating, set true if it's not.
	//!<
	//!< <BR>The <EM>menu_item</EM> can be a newly created GtkSeparatorMenuItem or an existing
	//!< GtkSeparatorMenuItem (see G::Object::Object).

//! @}

public:
//! @name Constructors
//! @{

	SeparatorMenuItem();
	//!< Construct a new separator menu item.

	
	virtual ~SeparatorMenuItem();
	//!< Destructor.
	
//! @}
//! @name Accessors
//! @{

	GtkSeparatorMenuItem* gtk_separator_menu_item() const { return (GtkSeparatorMenuItem*)instance; }
	//!< Get a pointer to the GtkSeparatorMenuItem structure.

	GtkSeparatorMenuItemClass* gtk_separator_menu_item_class() const;
	//!< Get a pointer to the GtkSeparatorMenuItemClass structure.

	operator GtkSeparatorMenuItem* () const;
	//!< Conversion operator; safely converts a SeparatorMenuItem to a GtkSeparatorMenuItem pointer.

//! @}
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_SEPARATOR_MENU_ITEM_H

