/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  editable_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_EDITABLE_CLASS_H
#define INTI_GTK_EDITABLE_CLASS_H

namespace Inti {

namespace Gtk {

class EditableClass
{
public:
	static void init(GtkEditableClass *g_iface);

// Methods
	static void do_insert_text_proxy(GtkEditable *editable, const gchar *text, gint length, gint *position);

	static void do_delete_text_proxy(GtkEditable *editable, gint start_pos, gint end_pos);

	static gchar* get_chars_proxy(GtkEditable *editable, gint start_pos, gint end_pos);

	static void set_selection_bounds_proxy(GtkEditable *editable, gint start_pos, gint end_pos);

	static gboolean get_selection_bounds_proxy(GtkEditable *editable, gint *start_pos, gint *end_pos);

	static void set_position_proxy(GtkEditable *editable, gint position);

	static gint get_position_proxy(GtkEditable *editable);

// Signals
	static void insert_text_proxy(GtkEditable *editable, const gchar *text, gint length, gint *position);

	static void delete_text_proxy(GtkEditable *editable, gint start_pos, gint end_pos);

	static void changed_proxy(GtkEditable *editable);
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_EDITABLE_CLASS_H

