/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
//! @file inti/gtk/eventbox.h
//! @brief A GtkEventBox C++ wrapper interface.
//!
//! Provides EventBox, a widget that can be used to catch events for widgets which
//! do not have their own window.

#ifndef INTI_GTK_EVENT_BOX_H
#define INTI_GTK_EVENT_BOX_H

#ifndef INTI_GTK_BIN_H
#include <inti/gtk/bin.h>
#endif

#ifndef __GTK_EVENT_BOX_H__
#include <gtk/gtkeventbox.h>
#endif

namespace Inti {

namespace Gtk {

class EventBoxClass;

//! @class EventBox eventbox.h inti/gtk/eventbox.h
//! @brief A GtkEventBox C++ wrapper class.
//!
//! The EventBox widget is a subclass of Bin which also has its own window. It is useful since
//! it allows you to catch events for widgets which do not have their own window.

class EventBox : public Bin
{
	friend class G::Object;
	friend class EventBoxClass;

	EventBox(const EventBox&);
	EventBox& operator=(const EventBox&);
	
protected:
//! @name Constructors
//! @{

	explicit EventBox(GtkEventBox *event_box, bool reference = false);
	//!< Construct a new EventBox from an existing GtkEventBox.
	//!< @param event_box A pointer to a GtkEventBox.
	//!< @param reference Set false if the initial reference count is floating, set true if it's not.
	//!<
	//!< <BR>The <EM>event_box</EM> can be a newly created GtkEventBox or an existing
	//!< GtkEventBox (see G::Object::Object).

//! @}

public:
//! @name Constructors
//! @{

	EventBox();
	//!< Construct a new EventBox.

	virtual ~EventBox();
	//!< Destructor.
	
//! @}
//! @name Accessors
//! @{

	GtkEventBox* gtk_event_box() const { return (GtkEventBox*)instance; }
	//!< Get a pointer to the GtkEventBox structure.

	GtkEventBoxClass* gtk_event_box_class() const;
	//!< Get a pointer to the GtkEventBoxClass structure.

	operator GtkEventBox* () const;
	//!< Conversion operator; safely converts an EventBox to a GtkEventBox pointer.

//! @}
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_EVENT_BOX_H

