/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  arrow.cc - GtkArrow C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "arrow.h"
#include "private/arrow_p.h"

using namespace Inti;

/*  Gtk::Arrow
 */

Gtk::Arrow::Arrow(GtkArrow *arrow, bool reference)
: Misc((GtkMisc*)arrow, reference)
{
}

Gtk::Arrow::Arrow()
: Misc((GtkMisc*)ArrowClass::create())
{
}

Gtk::Arrow::Arrow(ArrowType arrow_type, ShadowType shadow_type)
: Misc((GtkMisc*)ArrowClass::create())
{
	set(arrow_type, shadow_type);
}

Gtk::Arrow::~Arrow()
{
}

GtkArrowClass* 
Gtk::Arrow::gtk_arrow_class() const 
{
	return get_class<GtkArrowClass>(); 
}
	
Gtk::Arrow::operator GtkArrow* () const 
{ 
	return this ? gtk_arrow() : 0; 
}
	
void 
Gtk::Arrow::set(ArrowType arrow_type, ShadowType shadow_type)
{
	gtk_arrow_set(gtk_arrow(), (GtkArrowType)arrow_type, (GtkShadowType)shadow_type);
}

/*  Gtk::ArrowClass
 */

void
Gtk::ArrowClass::init(GtkArrowClass *g_class)
{
	MiscClass::init((GtkMiscClass*)g_class);
}

GType
Gtk::ArrowClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ARROW, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ArrowClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::Arrow::ArrowTypePropertyType Gtk::Arrow::arrow_type_property("arrow_type");

const Gtk::Arrow::ShadowTypePropertyType Gtk::Arrow::shadow_type_property("shadow_type");

