/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  text_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_TEXT_IFACE_H
#define INTI_ATK_TEXT_IFACE_H

namespace Inti {

namespace Atk {

class TextIface
{
public:
	static void init(AtkTextIface *g_iface);

// Methods
	static gchar* get_text_proxy(AtkText *text, gint start_offset, gint end_offset);

	static gchar* get_text_after_offset_proxy(AtkText *text, gint offset, AtkTextBoundary boundary_type, gint *start_offset, gint *end_offset);

	static gchar* get_text_at_offset_proxy(AtkText *text, gint offset, AtkTextBoundary boundary_type, gint *start_offset, gint *end_offset);

	static gunichar get_character_at_offset_proxy(AtkText *text, gint offset);

	static gchar* get_text_before_offset_proxy(AtkText *text, gint offset, AtkTextBoundary boundary_type, gint *start_offset, gint *end_offset);

	static gint get_caret_offset_proxy(AtkText *text);

	static AtkAttributeSet* get_run_attributes_proxy(AtkText *text, gint offset, gint *start_offset, gint *end_offset);

	static AtkAttributeSet* get_default_attributes_proxy(AtkText *text);

	static void get_character_extents_proxy(AtkText *text, gint offset, gint *x, gint *y, gint *width, gint *height, AtkCoordType coords);

	static gint get_character_count_proxy(AtkText *text);

	static gint get_offset_at_point_proxy(AtkText *text, gint  x, gint y, AtkCoordType coords);

	static gint	get_n_selections_proxy(AtkText *text);

	static gchar* get_selection_proxy(AtkText *text, gint selection_num, gint *start_offset, gint *end_offset);

	static gboolean add_selection_proxy(AtkText *text, gint start_offset, gint end_offset);

	static gboolean remove_selection_proxy(AtkText *text, gint selection_num);

	static gboolean set_selection_proxy(AtkText *text, gint selection_num, gint	start_offset, gint end_offset);

	static gboolean set_caret_offset_proxy(AtkText *text, gint offset);

// Signals
	static void text_changed_proxy(AtkText *text, gint position, gint length);

	static void text_caret_moved_proxy(AtkText *text, gint location);

	static void text_selection_changed_proxy(AtkText *text);
	
	static void text_attributes_changed_proxy(AtkText *text);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_TEXT_IFACE_H
