/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  selection_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_SELECTION_IFACE_H
#define INTI_ATK_SELECTION_IFACE_H

namespace Inti {

namespace Atk {

class SelectionIface
{
public:
	static void init(AtkSelectionIface *g_iface);

// Methods
	static gboolean add_selection_proxy(AtkSelection *selection, gint i);

	static gboolean clear_selection_proxy(AtkSelection *selection);

	static AtkObject* ref_selection_proxy(AtkSelection *selection, gint i);

	static gint get_selection_count_proxy(AtkSelection *selection);

	static gboolean is_child_selected_proxy(AtkSelection *selection, gint i);

	static gboolean remove_selection_proxy(AtkSelection *selection, gint i);

	static gboolean select_all_selection_proxy(AtkSelection *selection);

// Signals
	static void selection_changed_proxy(AtkSelection *selection);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_SELECTION_IFACE_H
