/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  hypertext_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_HYPERTEXT_IFACE_H
#define INTI_ATK_HYPERTEXT_IFACE_H

namespace Inti {

namespace Atk {

class HypertextIface
{
public:
	static void init(AtkHypertextIface *g_iface);

	static AtkHyperlink* get_link_proxy(AtkHypertext *hypertext, gint link_index);

	static gint get_n_links_proxy(AtkHypertext *hypertext);

	static gint get_link_index_proxy(AtkHypertext *hypertext, gint char_index);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_HYPERTEXT_IFACE_H
