/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  implementor.cc - AtkImplementor C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "implementor.h"
#include "private/implementor_p.h"
#include "object.h"

using namespace Inti;

/*  Atk::Implementor
 */
 
Atk::Implementor::~Implementor() 
{
}
	
AtkImplementorIface* 
Atk::Implementor::atk_implementor_iface() const 
{ 
	return peek<AtkImplementorIface>(ATK_TYPE_IMPLEMENTOR); 
}
	
Atk::Implementor::operator AtkImplementor* () const
{
	return this ? atk_implementor() : 0; 
}
	
Pointer<Atk::Object>
Atk::Implementor::ref_accessible() const
{

	return G::Object::wrap<Atk::Object>(atk_implementor_ref_accessible(atk_implementor()), true);
}

/*  Atk::ImplementorIface
 */

void
Atk::ImplementorIface::init(AtkImplementorIface *g_iface)
{
	g_iface->ref_accessible = &ref_accessible_proxy;
}

AtkObject*
Atk::ImplementorIface::ref_accessible_proxy(AtkImplementor *implementor)
{
	AtkObject *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(implementor));
	Atk::Implementor *tmp_implementor = dynamic_cast<Atk::Implementor*>(object);
	if (tmp_implementor)
		result = tmp_implementor->do_ref_accessible();
	else
	{
		AtkImplementorIface *tmp_iface = ATK_IMPLEMENTOR_GET_IFACE(implementor);
		AtkImplementorIface *g_iface = static_cast<AtkImplementorIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->ref_accessible)
			result = g_iface->ref_accessible(implementor);
	}
	return result;
}

/*  Overridable AtkImplementor methods
 */

AtkObject*
Atk::Implementor::do_ref_accessible()
{
	AtkObject *result = 0;
	AtkImplementorIface *g_iface = peek_parent<AtkImplementorIface>(atk_implementor_iface());
	if (g_iface->ref_accessible)
		result = g_iface->ref_accessible(atk_implementor());
	return result;
}

