/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  hypertext.cc - AtkHypertext C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "hypertext.h"
#include "private/hypertext_p.h"
#include "hyperlink.h"
#include "../glib/object.h"

using namespace Inti;

/*  Atk::Hypertext
 */

Atk::Hypertext::~Hypertext()
{
}
	
AtkHypertextIface* 
Atk::Hypertext::atk_hypertext_iface() const 
{ 
	return peek<AtkHypertextIface>(ATK_TYPE_HYPERTEXT); 
}
	
Atk::Hypertext::operator AtkHypertext* () const 
{ 
	return this ? atk_hypertext() : 0; 
}
	
Atk::Hyperlink*
Atk::Hypertext::get_link(int link_index) const
{
	AtkHyperlink *hyperlink = atk_hypertext_get_link(atk_hypertext(), link_index);
	return hyperlink ? G::Object::wrap<Hyperlink>(hyperlink) : 0;
}

int 
Atk::Hypertext::get_n_links(int char_index) const
{
	return atk_hypertext_get_n_links(atk_hypertext());
}

int 
Atk::Hypertext::get_link_index(int char_index) const
{
	return atk_hypertext_get_link_index(atk_hypertext(), char_index);
}

/*  Atk::HypertextIface
 */

void
Atk::HypertextIface::init(AtkHypertextIface *g_iface)
{
	g_iface->get_link = &get_link_proxy;
	g_iface->get_n_links = &get_n_links_proxy;
	g_iface->get_link_index = &get_link_index_proxy;
}

AtkHyperlink*
Atk::HypertextIface::get_link_proxy(AtkHypertext *hypertext, gint link_index)
{
	AtkHyperlink *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(hypertext));
	Atk::Hypertext *tmp_hypertext = dynamic_cast<Atk::Hypertext*>(object);
	if (tmp_hypertext)
		result = tmp_hypertext->do_get_link(link_index);
	else
	{
		AtkHypertextIface *g_iface = static_cast<AtkHypertextIface*>(g_type_interface_peek_parent(ATK_HYPERTEXT_GET_IFACE(hypertext)));
		if (g_iface->get_link)
			result = g_iface->get_link(hypertext, link_index);
	}
	return result;
}

gint
Atk::HypertextIface::get_n_links_proxy(AtkHypertext *hypertext)
{
	gint result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(hypertext));
	Atk::Hypertext *tmp_hypertext = dynamic_cast<Atk::Hypertext*>(object);
	if (tmp_hypertext)
		result = tmp_hypertext->do_get_n_links();
	else
	{
		AtkHypertextIface *g_iface = static_cast<AtkHypertextIface*>(g_type_interface_peek_parent(ATK_HYPERTEXT_GET_IFACE(hypertext)));
		if (g_iface->get_n_links)
			result = g_iface->get_n_links(hypertext);
	}
	return result;
}

gint
Atk::HypertextIface::get_link_index_proxy(AtkHypertext *hypertext, gint char_index)
{
	gint result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(hypertext));
	Atk::Hypertext *tmp_hypertext = dynamic_cast<Atk::Hypertext*>(object);
	if (tmp_hypertext)
		result = tmp_hypertext->do_get_link_index(char_index);
	else
	{
		AtkHypertextIface *tmp_iface = ATK_HYPERTEXT_GET_IFACE(hypertext);
		AtkHypertextIface *g_iface = static_cast<AtkHypertextIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->get_link_index)
			result = g_iface->get_link_index(hypertext, char_index);
	}
	return result;
}

/*  Overridable methods
 */

AtkHyperlink*
Atk::Hypertext::do_get_link(int link_index)
{
	AtkHyperlink *result = 0;
	AtkHypertextIface *g_iface = peek_parent<AtkHypertextIface>(atk_hypertext_iface());
	if (g_iface->get_link)
		result = g_iface->get_link(atk_hypertext(), link_index);
	return result;
}

int
Atk::Hypertext::do_get_n_links()
{
	int result = 0;
	AtkHypertextIface *g_iface = peek_parent<AtkHypertextIface>(atk_hypertext_iface());
	if (g_iface->get_n_links)
		result = g_iface->get_n_links(atk_hypertext());
	return result;
}

int
Atk::Hypertext::do_get_link_index(int char_index)
{
	int result = 0;
	AtkHypertextIface *g_iface = peek_parent<AtkHypertextIface>(atk_hypertext_iface());
	if (g_iface->get_link_index)
		result = g_iface->get_link_index(atk_hypertext(), char_index);
	return result;
}

