/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
//! @file inti/atk/document.h
//! @brief An AtkDocument C++ wrapper interface.
//!
//! Provides Document, an interface which allows access to a DOM associated with an object.

#ifndef INTI_ATK_DOCUMENT_H
#define INTI_ATK_DOCUMENT_H

#ifndef INTI_G_TYPE_H
#include <inti/glib/type.h>
#endif

#ifndef __ATK_DOCUMENT_H__
#include <atk/atkdocument.h>
#endif

namespace Inti {

namespace Atk {

class DocumentIface;

//! @class Document document.h inti/atk/document.h
//! @brief An AtkDocument C++ wrapper class.
//!
//! The Document interface should be supported by any object that has an associated 
//! document object model (DOM). This interface provides the standard mechanism 
//! allowing an assistive technology access to the DOM.

class Document : public virtual G::TypeInterface
{
	friend class DocumentIface;

protected:
//! @name Constructors
//! @{

	virtual ~Document() = 0;
	//!< Destructor.

//! @}
//  Override these do_ methods when you want to change the default behaviour of the AtkDocument.

	virtual const char* do_get_document_type();

	virtual void* do_get_document();

public:
//! @name Accessors
//! @{

	AtkDocument* atk_document() const { return (AtkDocument*)instance; }
	//!< Get a pointer to the AtkDocument structure.

	AtkDocumentIface* atk_document_iface() const;
	//!< Get a pointer to the AtkDocumentIface structure.

	operator AtkDocument* () const;
	//!< Conversion operator; safely converts a Document to an AtkDocument pointer.

	String get_document_type() const;
	//!< Gets a string indicating the document type.
	//!< @return A string indicating the document type.

	void* get_document() const;
	//!< Gets a generic pointer that points to an instance of the DOM.
	//!< @return A generic pointer that points to an instance of the DOM.
	//!< 
	//!< <BR>It is up to the caller to check the GType by calling G::TypeInstance::type()
	//!< to determine how to cast this pointer.

//! *}
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_DOCUMENT_H

